/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class CustomSpanNameAndAttributesTestCaseOpenTelemetry
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_SOURCE_SPAN_NAME = "pet-store-list-modified";
    public static final String EXPECTED_CUSTOM_SPAN_NAME = "customSpanName";
    public static final String FLOW_CUSTOM_SPAN_NAME_AND_ATTRIBUTES = "flow-custom-span-name-and-attributes";
    private static final int TIMEOUT_MILLIS = 5000;
    private static final int POLL_DELAY_MILLIS = 100;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    private ExportedSpanSniffer spanCapturer;
    @Inject
    PrivilegedProfilingService profilingService;

    @Before
    public void initialize() {
        this.spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
    }

    protected String getConfigFile() {
        return "tracing/custom-span-name-and-attributes.xml";
    }

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 1, CustomSpanNameAndAttributesTestCaseOpenTelemetry.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.MONITORING.name(), 2, CustomSpanNameAndAttributesTestCaseOpenTelemetry.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.DEBUG.name(), 2, CustomSpanNameAndAttributesTestCaseOpenTelemetry.getDebugExpectedSpanTestHierarchy()});
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_SOURCE_SPAN_NAME);
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_SOURCE_SPAN_NAME).beginChildren().child(EXPECTED_CUSTOM_SPAN_NAME).endChildren();
            CapturedExportedSpan capturedExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_CUSTOM_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span with customSpanName found!"));
            MatcherAssert.assertThat((Object)capturedExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attributeAddedByAddCurrentSpanAttribute", (Object)"ok"));
            MatcherAssert.assertThat((Object)capturedExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attributeAddedByAddCurrentSpanAttributes", (Object)"ok"));
            CapturedExportedSpan sourceExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_SOURCE_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No source exported span found!"));
            MatcherAssert.assertThat((Object)sourceExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)"dog", (Object)"Jack, the legendary fake border collie"));
            return expectedSpanHierarchy;
        };
    }

    public CustomSpanNameAndAttributesTestCaseOpenTelemetry(String tracingLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        this.configureTracingLevelSystemProperties(tracingLevel.toLowerCase());
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return CustomSpanNameAndAttributesTestCaseOpenTelemetry.getMonitoringExpectedSpanTestHierarchy();
    }

    @Test
    public void testCustomSpanNameAndAttributes() throws Exception {
        this.startFlow(FLOW_CUSTOM_SPAN_NAME_AND_ATTRIBUTES);
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = CustomSpanNameAndAttributesTestCaseOpenTelemetry.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == CustomSpanNameAndAttributesTestCaseOpenTelemetry.this.expectedSpansCount;
            }

            public String describeFailure() {
                return "No spans were captured";
            }
        });
        this.spanHierarchyRetriever.apply(this.spanCapturer.getExportedSpans()).assertSpanTree();
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }
}

