/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.TriFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideRoundRobinSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/round-robin-success.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/round-robin";
    private static final String FLOW_NAME = "round-robin-flow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_ROUND_ROBIN_SPAN_NAME = "mule:round-robin";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:round-robin:route";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String FLOW_LOCATION = "round-robin-flow";
    private static final String ROUND_ROBIN_LOCATION = "round-robin-flow/processors/0";
    private static final String LOGGER_ROUTE_0_LOCATION = "round-robin-flow/processors/0/route/0/processors/0";
    private static final String LOGGER_ROUTE_1_LOCATION = "round-robin-flow/processors/0/route/1/processors/0";
    private static final String SET_PAYLOAD_LOCATION = "round-robin-flow/processors/0/route/0/processors/1";
    private static final String TEST_ARTIFACT_ID = "OverrideRoundRobinSuccessOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpans;
    private final TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-round-robin-debug", 5, OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getOverviewRoundRobinDebugExpectedSpanTestHierarchy()}, {"overview-round-robin-monitoring", 5, OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getOverviewRoundRobinMonitoringExpectedSpanTestHierarchy()}, {"monitoring-round-robin-debug", 5, OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getMonitoringRoundRobinDebugExpectedSpanTestHierarchy()}, {"monitoring-round-robin-overview", 1, OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getMonitoringRoundRobinOverviewExpectedSpanTestHierarchy()}, {"debug-round-robin-monitoring", 5, OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getDebugRoundRobinMonitoringExpectedSpanTestHierarchy()}, {"debug-round-robin-overview", 1, OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getDebugRoundRobinOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideRoundRobinSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpans, TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpans = expectedSpans;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        String tracingLevelConfigurationFolderResourcePath = String.format("%s/%s", OVERRIDE_FOLDER_NAME, tracingLevelConf);
        this.configureTracingLevelSystemProperties(tracingLevelConfigurationFolderResourcePath);
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getOverviewRoundRobinDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId, verifySetPayloadInRoute) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            Map loggerSpanAttributeMap = verifySetPayloadInRoute != false ? TracingTestUtils.createAttributeMap((String)LOGGER_ROUTE_0_LOCATION, (String)artifactId) : TracingTestUtils.createAttributeMap((String)LOGGER_ROUTE_1_LOCATION, (String)artifactId);
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUND_ROBIN_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(loggerSpanAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence);
            if (verifySetPayloadInRoute.booleanValue()) {
                expectedSpanHierarchy.child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)SET_PAYLOAD_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence);
            }
            expectedSpanHierarchy.endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getOverviewRoundRobinMonitoringExpectedSpanTestHierarchy() {
        return OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getOverviewRoundRobinDebugExpectedSpanTestHierarchy();
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getMonitoringRoundRobinDebugExpectedSpanTestHierarchy() {
        return OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getOverviewRoundRobinDebugExpectedSpanTestHierarchy();
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getMonitoringRoundRobinOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId, verifySetPayloadInRoute) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence);
            return expectedSpanHierarchy;
        };
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getDebugRoundRobinMonitoringExpectedSpanTestHierarchy() {
        return OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getOverviewRoundRobinDebugExpectedSpanTestHierarchy();
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getDebugRoundRobinOverviewExpectedSpanTestHierarchy() {
        return OverrideRoundRobinSuccessOpenTelemetryTracingTestCase.getMonitoringRoundRobinOverviewExpectedSpanTestHierarchy();
    }

    @Test
    public void testFlow() throws Exception {
        this.assertRoundRobinSpan(this.profilingService.getSpanExportManager().getExportedSpanSniffer(), this.expectedSpans, true);
        this.assertRoundRobinSpan(this.profilingService.getSpanExportManager().getExportedSpanSniffer(), this.tracingLevelConf.endsWith("round-robin-overview") ? 1 : this.expectedSpans - 1, false);
        this.assertRoundRobinSpan(this.profilingService.getSpanExportManager().getExportedSpanSniffer(), this.expectedSpans, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRoundRobinSpan(final ExportedSpanSniffer spanCapturer, final int numberOfExpectedSpans, boolean verifySetPayloadInRoute) throws Exception {
        try {
            ((FlowRunner)this.flowRunner("round-robin-flow").withPayload((Object)"test")).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == numberOfExpectedSpans;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            ((SpanTestHierarchy)this.spanHierarchyRetriever.apply((Object)exportedSpans, (Object)("OverrideRoundRobinSuccessOpenTelemetryTracingTestCase#testFlow[TracingLevelConf: " + this.tracingLevelConf + "]"), (Object)verifySetPayloadInRoute)).assertSpanTree();
            exportedSpans.forEach(span -> MatcherAssert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

