/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class OpenTelemetryHttpErrorSemanticConventionAttributesAndNameTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    @Rule
    public SystemProperty addAncestorSpanId = new SystemProperty("mule.enable.mule.specific.tracing.information", "true");
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String ANCESTOR_MULE_SPAN_ID = "ancestor-mule-span-id";
    private static final String HTTP_LISTENER_ERROR_FLOW = "httpListenerError";
    private static final String HTTP_LISTENER_400_FLOW = "httpListenerError400";
    private static final String HTTP_LISTENER_500_FLOW = "httpListenerError500";
    private static final String REQUEST_400_FLOW = "requestTo400";
    private static final String REQUEST_500_FLOW = "requestTo500";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "GET";
    private static final String EXPECTED_HTTPS_REQUEST_SPAN_NAME = "GET";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "GET /test";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME_400 = "GET /test400";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME_500 = "GET /test500";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    public static final String NET_PEER_NAME = "net.peer.name";
    public static final String NET_PEER_PORT = "net.peer.port";
    public static final String HTTP_URL = "http.url";
    public static final String HTTP_METHOD = "http.method";
    public static final String HTTP_FLAVOR = "http.flavor";
    public static final String NET_HOST_NAME = "net.host.name";
    public static final String HTTP_TARGET = "http.target";
    public static final String HTTP_ROUTE = "http.route";
    public static final String HTTP_USER_AGENT = "http.user_agent";
    public static final String NET_HOST_PORT = "net.host.port";
    public static final String HTTP_SCHEME = "http.scheme";
    public static final String HTTP_STATUS_CODE = "http.status_code";
    public static final String SPAN_STATUS_ATTRIBUTE = "status.override";
    public static final String SPAN_KIND_ATTRIBUTE = "span.kind.override";
    @Inject
    PrivilegedProfilingService profilingService;
    @Rule
    public DynamicPort mockedServerPort = new DynamicPort("mockedServerPort");
    public final LazyValue<String> HTTP_URL_400 = new LazyValue(() -> String.format("https://localhost:%s/status/400", this.mockedServerPort.getValue()));
    public final LazyValue<String> HTTP_URL_500 = new LazyValue(() -> String.format("https://localhost:%s/status/500", this.mockedServerPort.getValue()));
    @Rule
    public DynamicPort listenerServerPort = new DynamicPort("listenerServerPort");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").needClientAuth(false).httpsPort(Integer.valueOf(this.mockedServerPort.getNumber())));

    @Before
    public void setUp() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/status/400")).willReturn(WireMock.aResponse().withStatus(400)));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/status/500")).willReturn(WireMock.aResponse().withStatus(500)));
    }

    protected String getConfigFile() {
        return "tracing/http-error-semantic-conventions-tracing.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowRequester400() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            PollingProber prober = new PollingProber(30000L, 100L);
            this.flowRunner(REQUEST_400_FLOW).runExpectingException(ErrorTypeMatcher.errorType((String)"HTTP", (String)"BAD_REQUEST"));
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 3;
                }

                public String describeFailure() {
                    return String.format("The exact amount of spans was not captured. Captured spans: %s", spanCapturer.getExportedSpans().toString());
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("HTTP:BAD_REQUEST").beginChildren().child("GET").addExceptionData("HTTP:BAD_REQUEST").child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals("GET")).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.mockedServerPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)((String)this.HTTP_URL_400.get())));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"400"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowRequester500() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            PollingProber prober = new PollingProber(30000L, 100L);
            this.flowRunner(REQUEST_500_FLOW).runExpectingException(ErrorTypeMatcher.errorType((String)"HTTP", (String)"INTERNAL_SERVER_ERROR"));
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 3;
                }

                public String describeFailure() {
                    return String.format("The exact amount of spans was not captured. Captured spans: %s", spanCapturer.getExportedSpans().toString());
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("HTTP:INTERNAL_SERVER_ERROR").beginChildren().child("GET").addExceptionData("HTTP:INTERNAL_SERVER_ERROR").child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals("GET")).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.mockedServerPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)((String)this.HTTP_URL_500.get())));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"500"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhenHTTPListenerFlowThrowsErrorSpanStatusShouldBeSetAsError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            PollingProber prober = new PollingProber(30000L, 100L);
            this.flowRunner(HTTP_LISTENER_ERROR_FLOW).dispatch();
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 6;
                }

                public String describeFailure() {
                    return String.format("The exact amount of spans was not captured. Captured spans: %s", spanCapturer.getExportedSpans().toString());
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("HTTP:INTERNAL_SERVER_ERROR").beginChildren().child("GET").addExceptionData("HTTP:INTERNAL_SERVER_ERROR").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).addExceptionData("CUSTOM:ERROR").beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("CUSTOM:ERROR").child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_FLOW_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)16));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)"/test"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"), Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"Mule HTTP Client")}));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.listenerServerPort.getValue()));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"500"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_ROUTE, (Object)"/test"));
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals("GET")).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.listenerServerPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.listenerServerPort.getValue() + "/test")));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"500"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhenHTTPListenerFlowThrowsErrorButReturns400SpanStatusShouldNotBeSetAsError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            PollingProber prober = new PollingProber(30000L, 100L);
            this.flowRunner(HTTP_LISTENER_400_FLOW).runExpectingException(ErrorTypeMatcher.errorType((String)"HTTP", (String)"BAD_REQUEST"));
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 6;
                }

                public String describeFailure() {
                    return String.format("The exact amount of spans was not captured. Captured spans: %s", spanCapturer.getExportedSpans().toString());
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("HTTP:BAD_REQUEST").beginChildren().child("GET").addExceptionData("HTTP:BAD_REQUEST").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME_400).addExceptionData("CUSTOM:ERROR").addStatusData("UNSET").addTraceStateKeyPresentAssertion(ANCESTOR_MULE_SPAN_ID).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("CUSTOM:ERROR").addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_FLOW_SPAN_NAME_400)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)16));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)"/test400"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"), Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"Mule HTTP Client")}));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.listenerServerPort.getValue()));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"400"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_ROUTE, (Object)"/test400"));
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals("GET")).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.listenerServerPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.listenerServerPort.getValue() + "/test400")));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"400"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhenHTTPListenerFlowDoesNotThrowErrorButReturns500SpanStatusShouldBeSetAsError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            PollingProber prober = new PollingProber(30000L, 100L);
            this.flowRunner(HTTP_LISTENER_500_FLOW).runExpectingException(ErrorTypeMatcher.errorType((String)"HTTP", (String)"INTERNAL_SERVER_ERROR"));
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 5;
                }

                public String describeFailure() {
                    return String.format("The exact amount of spans was not captured. Captured spans: %s", spanCapturer.getExportedSpans().toString());
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("HTTP:INTERNAL_SERVER_ERROR").beginChildren().child("GET").addExceptionData("HTTP:INTERNAL_SERVER_ERROR").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME_500).addStatusData("ERROR").addTraceStateKeyPresentAssertion(ANCESTOR_MULE_SPAN_ID).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_FLOW_SPAN_NAME_500)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)16));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)"/test500"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"), Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"Mule HTTP Client")}));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.listenerServerPort.getValue()));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"500"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_ROUTE, (Object)"/test500"));
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals("GET")).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.listenerServerPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.listenerServerPort.getValue() + "/test500")));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"500"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"ERROR"));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

