/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.TriFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class RoundRobinSuccessfulOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:round-robin:route";
    public static final String EXPECTED_ROUND_ROBIN_SPAN_NAME = "mule:round-robin";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String ROUND_ROBIN_FLOW = "round-robin-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String TEST_ARTIFACT_ID = "RoundRobinSuccessfulOpenTelemetryTracingTestCase#testRoundRobinFlow";
    private final String traceLevel;
    private final int expectedSpans;
    private final TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/round-robin-success.xml";
    }

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 1, RoundRobinSuccessfulOpenTelemetryTracingTestCase.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.MONITORING.name(), 5, RoundRobinSuccessfulOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy()}, {TracingLevel.DEBUG.name(), 5, RoundRobinSuccessfulOpenTelemetryTracingTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId, verifySetPayloadInRoute) -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME);
            return expectedSpanHierarchy;
        };
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId, verifySetPayloadInRoute) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            Map loggerSpanAttributeMap = verifySetPayloadInRoute != false ? TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0/route/0/processors/0", (String)artifactId) : TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0/route/1/processors/0", (String)artifactId);
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_FLOW, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUND_ROBIN_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(loggerSpanAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence);
            if (verifySetPayloadInRoute.booleanValue()) {
                expectedSpanHierarchy.child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0/route/0/processors/1", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence);
            }
            expectedSpanHierarchy.endChildren().endChildren().endChildren();
            exportedSpans.forEach(span -> MatcherAssert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
            return expectedSpanHierarchy;
        };
    }

    private static TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return RoundRobinSuccessfulOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy();
    }

    public RoundRobinSuccessfulOpenTelemetryTracingTestCase(String traceLevel, int expectedSpans, TriFunction<Collection<CapturedExportedSpan>, String, Boolean, SpanTestHierarchy> spanHierarchyRetriever) {
        this.traceLevel = traceLevel;
        this.expectedSpans = expectedSpans;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        this.configureTracingLevelSystemProperties(traceLevel.toLowerCase());
    }

    @Test
    public void testRoundRobinFlow() throws Exception {
        this.assertRoundRobinSpan(this.profilingService.getSpanExportManager().getExportedSpanSniffer(), this.expectedSpans, true);
        this.assertRoundRobinSpan(this.profilingService.getSpanExportManager().getExportedSpanSniffer(), this.traceLevel.equals("OVERVIEW") ? 1 : this.expectedSpans - 1, false);
        this.assertRoundRobinSpan(this.profilingService.getSpanExportManager().getExportedSpanSniffer(), this.expectedSpans, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRoundRobinSpan(final ExportedSpanSniffer spanCapturer, final int numberOfExpectedSpans, boolean verifySetPayloadInRoute) throws Exception {
        try {
            ((FlowRunner)this.flowRunner(ROUND_ROBIN_FLOW).withPayload((Object)"test")).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == numberOfExpectedSpans;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            ((SpanTestHierarchy)this.spanHierarchyRetriever.apply((Object)spanCapturer.getExportedSpans(), (Object)("RoundRobinSuccessfulOpenTelemetryTracingTestCase#testRoundRobinFlow[tracingLevel: " + this.traceLevel + "]"), (Object)verifySetPayloadInRoute)).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

