/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mule.runtime.tracer.api.sniffer.CapturedEventData;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;

public class OpenTelemetryProtobufSpanUtils {
    private static final String NO_PARENT_SPAN = "0000000000000000";

    public static List<? extends CapturedExportedSpan> getSpans(ExportTraceServiceRequest exportTraceServiceRequest) {
        return exportTraceServiceRequest.getResourceSpansList().stream().flatMap(resourceSpans -> OpenTelemetryProtobufSpanUtils.processResourceSpans(resourceSpans).stream()).collect(Collectors.toList());
    }

    private static List<SpanDataWrapper> processResourceSpans(ResourceSpans resourceSpans) {
        ArrayList spans = new ArrayList();
        String serviceName = resourceSpans.getResource().getAttributesList().stream().filter(kv -> kv.getKey().equals("service.name")).findAny().get().getValue().getStringValue();
        resourceSpans.getScopeSpansList().forEach(scopeSpans -> spans.addAll(scopeSpans.getSpansList()));
        return spans.stream().map(span -> new SpanDataWrapper(serviceName, (Span)span)).collect(Collectors.toList());
    }

    public static void verifyResourceAndScopeGrouping(ExportTraceServiceRequest request) {
        MatcherAssert.assertThat((String)"The number of expected resources for the export request is not 1. In the mule runtime there is only one resource per app", (Object)request.getResourceSpansCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"The number of expected instrumentation scopes for the export request is not 1. In the mule runtime there is only one scope, which corresponds to the instrumentation code/library for open telemetry export module.", (Object)request.getResourceSpans(0).getScopeSpansCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    private static final class SpanDataWrapper
    implements CapturedExportedSpan {
        private final Span openTelemetryProtobufSpan;
        private final String serviceName;

        public SpanDataWrapper(String serviceName, Span openTelemetryProtobufSpan) {
            this.serviceName = serviceName;
            this.openTelemetryProtobufSpan = openTelemetryProtobufSpan;
        }

        public String getName() {
            return this.openTelemetryProtobufSpan.getName();
        }

        public String getParentSpanId() {
            String parentSpanId = HexFormat.of().formatHex(this.openTelemetryProtobufSpan.getParentSpanId().toByteArray());
            if (StringUtils.isEmpty((CharSequence)parentSpanId)) {
                parentSpanId = OpenTelemetryProtobufSpanUtils.NO_PARENT_SPAN;
            }
            return parentSpanId;
        }

        public String getSpanId() {
            return HexFormat.of().formatHex(this.openTelemetryProtobufSpan.getSpanId().toByteArray());
        }

        public String getTraceId() {
            return HexFormat.of().formatHex(this.openTelemetryProtobufSpan.getTraceId().toByteArray());
        }

        public Map<String, String> getAttributes() {
            return this.openTelemetryProtobufSpan.getAttributesList().stream().collect(Collectors.toMap(KeyValue::getKey, attributeKeyValue -> attributeKeyValue.getValue().getStringValue()));
        }

        public List<CapturedEventData> getEvents() {
            return this.openTelemetryProtobufSpan.getEventsList().stream().map(OpenTelemetryCapturedProtoEventData::new).collect(Collectors.toList());
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getSpanKindName() {
            return this.openTelemetryProtobufSpan.getKind().name();
        }

        public boolean hasErrorStatus() {
            return !this.openTelemetryProtobufSpan.getStatus().getCode().equals((Object)Status.StatusCode.STATUS_CODE_OK);
        }

        public String getStatusAsString() {
            return StatusCode.values()[this.openTelemetryProtobufSpan.getStatus().getCodeValue()].name();
        }

        public String toString() {
            return String.format("a span with name: [%s], ID: [%s] and parent Span ID: [%s]", this.getName(), this.getSpanId(), this.getParentSpanId());
        }

        public long getStartEpochSpanNanos() {
            return this.openTelemetryProtobufSpan.getStartTimeUnixNano();
        }

        public long getEndSpanEpochNanos() {
            return this.openTelemetryProtobufSpan.getEndTimeUnixNano();
        }

        public Map<String, String> getTraceState() {
            if (!this.openTelemetryProtobufSpan.getTraceState().isEmpty()) {
                return W3CTraceContextEncoding.decodeTraceState((String)this.openTelemetryProtobufSpan.getTraceState()).asMap();
            }
            return Collections.emptyMap();
        }
    }

    private static class OpenTelemetryCapturedProtoEventData
    implements CapturedEventData {
        private final String name;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public OpenTelemetryCapturedProtoEventData(Span.Event protoEvent) {
            this.name = protoEvent.getName();
            protoEvent.getAttributesList().forEach(attributeKeyValue -> this.attributes.put(attributeKeyValue.getKey(), attributeKeyValue.getValue().getStringValue()));
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }
}

