/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/choice-router.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/choice-route";
    private static final String FLOW_NAME = "choice-flow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_CHOICE_SPAN_NAME = "mule:choice";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:choice:route";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String CHOICE_FLOW_LOCATION = "choice-flow";
    private static final String CHOICE_ROUTE_LOCATION = "choice-flow/processors/0";
    private static final String LOGGER_LOCATION = "choice-flow/processors/0/route/0/processors/0";
    private static final String SET_PAYLOAD_LOCATION = "choice-flow/processors/0/route/2/processors/0";
    private static final String TEST_ARTIFACT_ID = "OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-choice-route-debug", 4, OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getOverviewChoiceRouteDebugExpectedSpanTestHierarchy()}, {"overview-choice-route-monitoring", 4, OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getOverviewChoiceRouteMonitoringExpectedSpanTestHierarchy()}, {"monitoring-choice-route-debug", 4, OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getMonitoringChoiceRouteDebugExpectedSpanTestHierarchy()}, {"monitoring-choice-route-overview", 1, OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getMonitoringChoiceRouteOverviewExpectedSpanTestHierarchy()}, {"debug-choice-route-monitoring", 4, OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getDebugChoiceRouteMonitoringExpectedSpanTestHierarchy()}, {"debug-choice-route-overview", 1, OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getDebugChoiceRouteOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getOverviewChoiceRouteDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, spanTestHierarchyParameters) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow", (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CHOICE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_ROUTE_LOCATION, (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_ROUTE_LOCATION, (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(spanTestHierarchyParameters.getChildSpanName()).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)spanTestHierarchyParameters.getChildSpanLocation(), (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getOverviewChoiceRouteMonitoringExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getOverviewChoiceRouteDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getMonitoringChoiceRouteDebugExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getOverviewChoiceRouteDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getMonitoringChoiceRouteOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, spanTestHierarchyParameters) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow", (String)spanTestHierarchyParameters.getArtifactId())).addAttributesToAssertExistence(attributesToAssertExistence);
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getDebugChoiceRouteMonitoringExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getOverviewChoiceRouteDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, SpanTestHierarchyParameters, SpanTestHierarchy> getDebugChoiceRouteOverviewExpectedSpanTestHierarchy() {
        return OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.getMonitoringChoiceRouteOverviewExpectedSpanTestHierarchy();
    }

    @Test
    public void testFlow() throws Exception {
        this.testForRoute(EXPECTED_LOGGER_SPAN_NAME, LOGGER_LOCATION);
        this.testForRoute(EXPECTED_SET_PAYLOAD_SPAN_NAME, SET_PAYLOAD_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testForRoute(String childExpectedSpan, String childExpectedLocation) throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner("choice-flow").withPayload((Object)childExpectedSpan)).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            String artifactId = "OverrideChoiceRouteSuccessOpenTelemetryTracingTestCase#testFlow[TracingLevelConf: " + this.tracingLevelConf + "]";
            this.spanHierarchyRetriever.apply(exportedSpans, new SpanTestHierarchyParameters(artifactId, childExpectedSpan, childExpectedLocation)).assertSpanTree();
            exportedSpans.forEach(span -> MatcherAssert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    private static final class SpanTestHierarchyParameters {
        private final String artifactId;
        private final String childSpanName;
        private final String childSpanLocation;

        private SpanTestHierarchyParameters(String artifactId, String childSpanName, String childSpanLocation) {
            this.artifactId = artifactId;
            this.childSpanName = childSpanName;
            this.childSpanLocation = childSpanLocation;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getChildSpanName() {
            return this.childSpanName;
        }

        public String getChildSpanLocation() {
            return this.childSpanLocation;
        }
    }
}

