/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideRoundRobinErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/round-robin-error.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/round-robin";
    private static final String FLOW_NAME = "round-robin-flow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_ROUND_ROBIN_SPAN_NAME = "mule:round-robin";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:round-robin:route";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    private static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN = "mule:on-error-propagate";
    private static final String ANY_EXPECTED_ERROR_TYPE = "ANY:EXPECTED";
    private static final String FLOW_LOCATION = "round-robin-flow";
    private static final String ROUND_ROBIN_LOCATION = "round-robin-flow/processors/0";
    private static final String LOGGER_LOCATION = "round-robin-flow/processors/0/route/0/processors/0";
    private static final String RAISE_ERROR_LOCATION = "round-robin-flow/processors/0/route/0/processors/1";
    private static final String UNKNOWN_LOCATION = "unknown";
    private static final String TEST_ARTIFACT_ID = "OverrideRoundRobinErrorOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-round-robin-debug", 5, OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getOverviewRoundRobinDebugExpectedSpanTestHierarchy()}, {"overview-round-robin-monitoring", 5, OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getOverviewRoundRobinMonitoringExpectedSpanTestHierarchy()}, {"monitoring-round-robin-debug", 6, OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getMonitoringRoundRobinDebugExpectedSpanTestHierarchy()}, {"monitoring-round-robin-overview", 2, OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getMonitoringRoundRobinOverviewExpectedSpanTestHierarchy()}, {"debug-round-robin-monitoring", 6, OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getDebugRoundRobinMonitoringExpectedSpanTestHierarchy()}, {"debug-round-robin-overview", 2, OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getDebugRoundRobinOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideRoundRobinErrorOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewRoundRobinDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUND_ROBIN_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)LOGGER_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)RAISE_ERROR_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewRoundRobinMonitoringExpectedSpanTestHierarchy() {
        return OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getOverviewRoundRobinDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringRoundRobinDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUND_ROBIN_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)LOGGER_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)RAISE_ERROR_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)UNKNOWN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringRoundRobinOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)UNKNOWN_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugRoundRobinMonitoringExpectedSpanTestHierarchy() {
        return OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getMonitoringRoundRobinDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugRoundRobinOverviewExpectedSpanTestHierarchy() {
        return OverrideRoundRobinErrorOpenTelemetryTracingTestCase.getMonitoringRoundRobinOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner("round-robin-flow").withPayload((Object)"test")).runExpectingException();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideRoundRobinErrorOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans, "OverrideRoundRobinErrorOpenTelemetryTracingTestCase#testFlow[TracingLevelConf: " + this.tracingLevelConf + "]").assertSpanTree();
            exportedSpans.forEach(span -> MatcherAssert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

