/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@Ignore(value="To be completed after W-20062420")
public class ExportConfigurationChangeTestCase
extends MuleArtifactFunctionalTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String FLOW_LOCATION = "flow";
    private static final String SET_PAYLOAD_LOCATION = "flow/processors/0";
    private static final String TEST_ARTIFACT_ID = "ExportConfigurationChangeTestCase";
    private static final int TIMEOUT_MILLIS = 10000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final int MAX_BACKOFF_ATTEMPTS = 2;
    private File exporterConfigFile;
    private File tracingLevelFile;
    @ClassRule
    public static final TestServerRule server1 = new TestServerRule();
    @ClassRule
    public static final TestServerRule server2 = new TestServerRule();

    protected String getConfigFile() {
        return "tracing/export-configuration-change.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        File confFolder = this.getConfFolder();
        this.exporterConfigFile = new File(confFolder, "tracer-exporter-test.conf");
        this.writeExporterConfig(this.exporterConfigFile, false, server1.httpPort(), "HTTP");
        this.tracingLevelFile = new File(confFolder, "tracing-level.conf");
        this.writeTracingLevelConfig(this.tracingLevelFile, TracingLevel.MONITORING, null);
        System.setProperty("mule.openTelemetry.tracer.exporter.configurationFileName", this.exporterConfigFile.getName());
        System.setProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", confFolder.getAbsolutePath());
        System.out.println("DEBUG: Set MULE_OPEN_TELEMETRY_TRACING_CONFIGURATION_FILE_PATH to: " + confFolder.getAbsolutePath());
        System.setProperty("mule.openTelemetry.tracer.exporter.use.sniffer", "true");
        System.setProperty("mule.openTelemetry.tracer.exporter.sampler.type", "always_on");
        System.setProperty("mule.observability.configuration.configurationFileWatcherDelay", "100");
    }

    private File getConfFolder() {
        URL testClassUrl = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File testClasses = new File(testClassUrl.getPath());
        File confFolder = new File(testClasses, "conf");
        if (!confFolder.exists()) {
            confFolder.mkdirs();
        }
        System.out.println("DEBUG: Using conf folder: " + confFolder.getAbsolutePath());
        System.out.println("DEBUG: Conf folder exists: " + confFolder.exists());
        return confFolder;
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.openTelemetry.tracer.exporter.configurationFileName");
        System.clearProperty("mule.openTelemetry.tracer.exporter.configurationFilePath");
        System.clearProperty("mule.openTelemetry.tracer.exporter.use.sniffer");
        System.clearProperty("mule.openTelemetry.tracer.exporter.sampler.type");
        System.clearProperty("mule.observability.configuration.configurationFileWatcherDelay");
        server1.reset();
        server2.reset();
        File confFolder = new File("target/test-classes/conf");
        if (confFolder.exists()) {
            new File(confFolder, "tracer-exporter-test.conf").delete();
            new File(confFolder, "tracing-level.conf").delete();
        }
    }

    @Test
    @Ignore(value="To be completed after W-20062420")
    public void testExporterEnabledDisabledReload() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)0));
        this.writeExporterConfig(this.exporterConfigFile, true, server1.httpPort(), "HTTP");
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)2));
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeMonitoring(server1.getCapturedExportedSpans());
        this.writeExporterConfig(this.exporterConfigFile, false, server1.httpPort(), "HTTP");
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() == 0;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    @Ignore(value="To be completed after W-20062420")
    public void testExporterEndpointReload() throws Exception {
        this.writeExporterConfig(this.exporterConfigFile, true, server1.httpPort(), "HTTP");
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)2));
        this.writeExporterConfig(this.exporterConfigFile, true, server2.httpPort(), "HTTP");
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                server2.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server2.getCapturedExportedSpans().size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server2.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    @Ignore(value="To be completed after W-20062420")
    public void testTracingLevelReload() throws Exception {
        this.writeExporterConfig(this.exporterConfigFile, true, server1.httpPort(), "HTTP");
        this.writeTracingLevelConfig(this.tracingLevelFile, TracingLevel.MONITORING, null);
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() == 2;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)2));
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeMonitoring(server1.getCapturedExportedSpans());
        this.writeTracingLevelConfig(this.tracingLevelFile, TracingLevel.OVERVIEW, null);
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() == 1;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)1));
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeOverview(server1.getCapturedExportedSpans());
    }

    @Test
    @Ignore(value="To be completed after W-20062420")
    public void testTracingLevelOverridesReload() throws Exception {
        this.writeExporterConfig(this.exporterConfigFile, true, server1.httpPort(), "HTTP");
        this.writeTracingLevelConfig(this.tracingLevelFile, TracingLevel.OVERVIEW, null);
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() == 1;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)1));
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeOverview(server1.getCapturedExportedSpans());
        this.writeTracingLevelConfig(this.tracingLevelFile, TracingLevel.OVERVIEW, List.of("flow=MONITORING"));
        this.waitForBehaviorChange(() -> {
            try {
                server1.reset();
                ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run();
                return server1.getCapturedExportedSpans().size() == 2;
            }
            catch (Exception e) {
                return false;
            }
        });
        MatcherAssert.assertThat(server1.getCapturedExportedSpans(), (Matcher)Matchers.hasSize((int)2));
        ExportConfigurationChangeTestCase.assertExpectedSpanTreeMonitoring(server1.getCapturedExportedSpans());
    }

    private void waitForBehaviorChange(final Supplier<Boolean> condition) {
        new PollingProber(10000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() {
                try {
                    return (Boolean)condition.get();
                }
                catch (Exception e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Configuration reload was not detected within 10000ms";
            }
        });
    }

    private void writeExporterConfig(File file, boolean enabled, int port, String type) throws IOException {
        String content = String.format("mule:\n  openTelemetry:\n    tracer:\n      exporter:\n        enabled: %s\n        type: %s\n        endpoint: \"http://localhost:%d\"\n        sampler: ALWAYS_ON\n", enabled, type, port);
        Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        file.setLastModified(System.currentTimeMillis());
    }

    private void writeTracingLevelConfig(File file, TracingLevel level, List<String> overrides) throws IOException {
        StringBuilder content = new StringBuilder();
        content.append("mule:\n");
        content.append("  openTelemetry:\n");
        content.append("    tracer:\n");
        content.append("      level: ").append(level.name()).append("\n");
        if (overrides != null && !overrides.isEmpty()) {
            content.append("      levelOverrides:\n");
            for (String override : overrides) {
                content.append("        - \"").append(override).append("\"\n");
            }
        }
        Files.write(file.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        file.setLastModified(System.currentTimeMillis());
    }

    private static void assertExpectedSpanTreeOverview(Collection<CapturedExportedSpan> exportedSpans) {
        List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)FLOW_LOCATION, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence);
        expectedSpanHierarchy.assertSpanTree();
    }

    private static void assertExpectedSpanTreeMonitoring(Collection<CapturedExportedSpan> exportedSpans) {
        List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
        Map setPayloadAttributeMap = TracingTestUtils.createAttributeMap((String)SET_PAYLOAD_LOCATION, (String)TEST_ARTIFACT_ID);
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)FLOW_LOCATION, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertValue(setPayloadAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    private static final class TestServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();
        private final AtomicInteger exportAttempts = new AtomicInteger(0);

        private TestServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractHttpService(){

                @NotNull
                protected HttpResponse doPost(@NotNull ServiceRequestContext ctx, @NotNull HttpRequest req) {
                    return HttpResponse.from((CompletableFuture)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        if (exportAttempts.incrementAndGet() < 2) {
                            responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.REQUEST_TIMEOUT));
                            return res;
                        }
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((InputStream)new ByteArrayInputStream(aReq.content().array()))));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public List<CapturedExportedSpan> getCapturedExportedSpans() {
            return this.capturedExportedSpans;
        }

        public void reset() {
            this.capturedExportedSpans.clear();
        }
    }
}

