/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    @Rule
    public SystemProperty addAncestorSpanId = new SystemProperty("mule.enable.mule.specific.tracing.information", "true");
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String STARTING_FLOW = "startingFlow";
    private static final String HTTP_FLOW_URI_PARAMS = "httpRequestUriParams";
    private static final String HTTP_LISTENER_ERROR_200_FLOW = "httpListenerErrorButReturns200";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "GET";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "GET /test";
    private static final String EXPECTED_HTTP_URI_PARAMS_FLOW_SPAN_NAME = "GET /{uriParam1}/{uriParam2}";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME_200 = "GET /test200";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    public static final String NET_PEER_NAME = "net.peer.name";
    public static final String NET_PEER_PORT = "net.peer.port";
    public static final String HTTP_URL = "http.url";
    public static final String HTTP_METHOD = "http.method";
    public static final String HTTP_FLAVOR = "http.flavor";
    public static final String NET_HOST_NAME = "net.host.name";
    public static final String HTTP_TARGET = "http.target";
    public static final String HTTP_USER_AGENT = "http.user_agent";
    public static final String NET_HOST_PORT = "net.host.port";
    public static final String HTTP_SCHEME = "http.scheme";
    public static final String HTTP_STATUS_CODE = "http.status_code";
    public static final String HTTP_ROUTE = "http.route";
    public static final String SPAN_KIND_ATTRIBUTE = "span.kind.override";
    public static final String SPAN_STATUS_ATTRIBUTE = "status.override";
    public static final String ANCESTOR_MULE_SPAN_ID = "ancestor-mule-span-id";
    private final String tracingLevel;
    private final int expectedSpansForSuccessCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchySuccessRetriever;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchySuccessUriRetriever;
    private final int expectedSpansForErrorCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyErrorRetriever;
    @Inject
    PrivilegedProfilingService profilingService;
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 3, OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getOverviewExpectedSpanTestHierarchyForSuccessFlow(EXPECTED_HTTP_FLOW_SPAN_NAME), 3, OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getOverviewExpectedSpanTestHierarchyForErrorFlow(), OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getOverviewExpectedSpanTestHierarchyForSuccessFlow(EXPECTED_HTTP_URI_PARAMS_FLOW_SPAN_NAME)}, {TracingLevel.MONITORING.name(), 4, OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getMonitoringExpectedSpanTestHierarchyForSuccessFlow(EXPECTED_HTTP_FLOW_SPAN_NAME), 5, OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getMonitoringExpectedSpanTestHierarchyForErrorFlow(), OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getMonitoringExpectedSpanTestHierarchyForSuccessFlow(EXPECTED_HTTP_URI_PARAMS_FLOW_SPAN_NAME)}, {TracingLevel.DEBUG.name(), 19, OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getDebugExpectedSpanTestHierarchyForSuccessFlow(EXPECTED_HTTP_FLOW_SPAN_NAME), 20, OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getDebugExpectedSpanTestHierarchyForErrorFlow(), OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.getDebugExpectedSpanTestHierarchyForSuccessFlow(EXPECTED_HTTP_URI_PARAMS_FLOW_SPAN_NAME)});
    }

    public OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase(String tracingLevel, int expectedSpansForSuccessCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchySuccessRetriever, int expectedSpansForErrorCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyErrorRetriever, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchySuccessUriRetriever) {
        this.tracingLevel = tracingLevel;
        this.expectedSpansForSuccessCount = expectedSpansForSuccessCount;
        this.expectedSpansForErrorCount = expectedSpansForErrorCount;
        this.spanHierarchySuccessRetriever = spanHierarchySuccessRetriever;
        this.spanHierarchyErrorRetriever = spanHierarchyErrorRetriever;
        this.spanHierarchySuccessUriRetriever = spanHierarchySuccessUriRetriever;
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchyForSuccessFlow(String httpFlowSpanName) {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(httpFlowSpanName).addTraceStateKeyPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchyForSuccessFlow(String httpFlowSpanName) {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(httpFlowSpanName).addTraceStateKeyPresentAssertion(ANCESTOR_MULE_SPAN_ID).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchyForSuccessFlow(String httpFlowSpanName) {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:get-connection").child("mule:operation-execution").beginChildren().child(httpFlowSpanName).addTraceStateKeyPresentAssertion(ANCESTOR_MULE_SPAN_ID).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren().endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchyForErrorFlow() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:get-connection").child("mule:operation-execution").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME_200).addExceptionData("ANY:EXPECTED").addStatusData("UNSET").addTraceStateKeyPresentAssertion(ANCESTOR_MULE_SPAN_ID).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("ANY:EXPECTED").addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addTraceStateKeyNotPresentAssertion(ANCESTOR_MULE_SPAN_ID).endChildren().endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchyForErrorFlow() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME_200).addExceptionData("ANY:EXPECTED").addStatusData("UNSET").beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData("ANY:EXPECTED").child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchyForErrorFlow() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME_200).addExceptionData("ANY:EXPECTED").addStatusData("UNSET").endChildren();
            return expectedSpanHierarchy;
        };
    }

    protected String getConfigFile() {
        return "tracing/http-semantic-conventions-tracing.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        System.setProperty("mule.tracing.level.configuration.path", this.tracingLevel.toLowerCase() + FileSystems.getDefault().getSeparator());
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            this.flowRunner(STARTING_FLOW).run();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.this.expectedSpansForSuccessCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchySuccessRetriever.apply(exportedSpans).assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_FLOW_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)16));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)"/test"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"), Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"Mule HTTP Client")}));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.httpPort.getValue()));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)EXPECTED_HTTP_REQUEST_SPAN_NAME));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_ROUTE, (Object)"/test"));
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_REQUEST_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.httpPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.httpPort.getValue() + "/test")));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)EXPECTED_HTTP_REQUEST_SPAN_NAME));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessFlowWithUriParams() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            this.flowRunner(HTTP_FLOW_URI_PARAMS).run();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.this.expectedSpansForSuccessCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchySuccessUriRetriever.apply(exportedSpans).assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_URI_PARAMS_FLOW_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)16));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)"/{uriParam1}/{uriParam2}"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"), Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"Mule HTTP Client")}));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.httpPort.getValue()));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)EXPECTED_HTTP_REQUEST_SPAN_NAME));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_ROUTE, (Object)"/{uriParam1}/{uriParam2}"));
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_REQUEST_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.httpPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.httpPort.getValue() + "/param1/param2")));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)EXPECTED_HTTP_REQUEST_SPAN_NAME));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
        }
        finally {
            spanCapturer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhenHTTPListenerFlowThrowsErrorButReturns200SpanStatusShouldNotBeSetAsError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            PollingProber prober = new PollingProber(30000L, 100L);
            this.flowRunner(HTTP_LISTENER_ERROR_200_FLOW).dispatch();
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OpenTelemetryHttpSemanticConventionAttributesAndNameTestCase.this.expectedSpansForErrorCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyErrorRetriever.apply(exportedSpans).assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_FLOW_SPAN_NAME_200)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)16));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)"/test200"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"), Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"Mule HTTP Client")}));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.httpPort.getValue()));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)EXPECTED_HTTP_REQUEST_SPAN_NAME));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_ROUTE, (Object)"/test200"));
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)listenerExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            MatcherAssert.assertThat((Object)listenerExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)listenerExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_REQUEST_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.httpPort.getValue()));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.httpPort.getValue() + "/test200")));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)EXPECTED_HTTP_REQUEST_SPAN_NAME));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            MatcherAssert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)((String)requestExportedSpan.getAttributes().get(SPAN_STATUS_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
            MatcherAssert.assertThat((Object)requestExportedSpan.hasErrorStatus(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)requestExportedSpan.getStatusAsString(), (Matcher)Matchers.equalTo((Object)"UNSET"));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

