/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.test.service;

import static org.mule.test.allure.AllureConstants.ClassloadingIsolationFeature.CLASSLOADING_ISOLATION;
import static org.mule.test.allure.AllureConstants.JpmsFeature.JPMS_FEATURE;
import static org.mule.test.allure.AllureConstants.ServicesFeature.SERVICES;

import static java.util.Collections.emptyMap;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.notNullValue;

import static org.junit.jupiter.api.Assertions.assertThrows;

import org.mule.functional.junit4.ArtifactAstXmlParserConfigurationBuilder;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.additional.api.test.TestService;
import org.mule.runtime.core.api.config.ConfigurationBuilder;

import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import jakarta.inject.Inject;

@Features({
    @Feature(SERVICES),
    @Feature(JPMS_FEATURE),
    @Feature(CLASSLOADING_ISOLATION)})
public class ServiceLibWithPrivilegedAdditionalLibTestCase extends MuleArtifactFunctionalTestCase {

  @Inject
  private TestService testService;

  @Override
  protected ConfigurationBuilder getBuilder() throws Exception {
    var builder = new ArtifactAstXmlParserConfigurationBuilder(emptyMap(),
                                                               disableXmlValidations(),
                                                               enableLazyInit(),
                                                               false,
                                                               false,
                                                               new String[] {},
                                                               getExpressionLanguageMetadataService());
    configureSpringConfigurationBuilder(builder);
    return builder;
  }

  @Test
  public void serviceLoadedAndInjected() {
    assertThat(testService, notNullValue());
  }

  @Test
  public void javaAccessRestrictionsEnforced() {
    var thrown = assertThrows(IllegalAccessError.class, () -> testService.doSomething());
    assertThat(thrown.getMessage(),
               containsString("cannot access class org.mule.runtime.additional.api.test.TestService (in module org.mule.runtime.additional) because module org.mule.runtime.additional does not export org.mule.runtime.additional.api.test to"));
  }
}
