/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.utils.TroubleshootingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourcesResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PluginUrlClassification resolvePluginResourcesFor(PluginUrlClassification pluginUrlClassification) {
        PluginUrlClassification pluginUrlClassification2;
        HashSet<String> exportPackages = new HashSet<String>();
        HashSet<String> exportResources = new HashSet<String>();
        HashSet<String> privilegedExportedPackages = new HashSet<String>();
        HashSet<String> privilegedArtifacts = new HashSet<String>();
        URLClassLoader classLoader = new URLClassLoader(pluginUrlClassification.getUrls().toArray(new URL[0]), null);
        try {
            MulePluginModel mulePluginModel;
            String MULE_ARTIFACT_JSON_PATH_INSIDE_JAR = "META-INF/mule-artifact/mule-artifact.json";
            String pluginDescriptorLocation = "META-INF/mule-artifact/mule-artifact.json";
            this.logger.debug("Loading plugin '{}' descriptor", (Object)pluginUrlClassification.getName());
            URL pluginJsonUrl = classLoader.getResource("META-INF/mule-artifact/mule-artifact.json");
            if (pluginJsonUrl == null) {
                pluginJsonUrl = classLoader.getResource("META-INF/auto-generated-mule-artifact.json");
                if (pluginJsonUrl == null) {
                    throw new IllegalStateException("mule-artifact.json couldn't be found for plugin: " + pluginUrlClassification.getName());
                }
                pluginDescriptorLocation = "META-INF/auto-generated-mule-artifact.json";
            }
            this.logger.debug("Loading plugin '{}' descriptor (from path: {}) using classloader {}", new Object[]{pluginUrlClassification.getName(), pluginDescriptorLocation, classLoader.getURLs()});
            try {
                mulePluginModel = (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(IOUtils.toString((InputStream)classLoader.getResourceAsStream(pluginDescriptorLocation)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read extension describer on plugin '%s' from JAR with MD5 '%s'", pluginJsonUrl, TroubleshootingUtils.getMD5FromFile(pluginJsonUrl)), e);
            }
            Map attributes = mulePluginModel.getClassLoaderModelLoaderDescriptor().getAttributes();
            exportPackages.addAll(attributes.getOrDefault("exportedPackages", Collections.emptyList()));
            exportResources.addAll(attributes.getOrDefault("exportedResources", Collections.emptyList()));
            privilegedExportedPackages.addAll(attributes.getOrDefault("privilegedExportedPackages", Collections.emptyList()));
            privilegedArtifacts.addAll(attributes.getOrDefault("privilegedArtifactIds", Collections.emptyList()));
            pluginUrlClassification2 = new PluginUrlClassification(pluginUrlClassification.getName(), pluginUrlClassification.getUrls(), pluginUrlClassification.getExportClasses(), pluginUrlClassification.getPluginBundleDescriptor(), pluginUrlClassification.getPluginDependencies(), exportPackages, exportResources, privilegedExportedPackages, privilegedArtifacts);
        }
        catch (Throwable throwable) {
            try {
                try {
                    classLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        classLoader.close();
        return pluginUrlClassification2;
    }
}

