/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.discoverer.ImmutableServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.MuleServiceModelLoader;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.tck.util.ClassUtils;

public class IsolatedServiceProviderDiscoverer
implements ServiceProviderDiscoverer {
    private final List<ArtifactClassLoader> serviceArtifactClassLoaders;

    public IsolatedServiceProviderDiscoverer(List<ArtifactClassLoader> serviceArtifactClassLoaders) {
        Objects.requireNonNull(serviceArtifactClassLoaders, "serviceArtifactClassLoaders cannot be null");
        this.serviceArtifactClassLoaders = serviceArtifactClassLoaders;
    }

    public List<ServiceAssembly> discover() throws ServiceResolutionError {
        LinkedList<ServiceAssembly> locators = new LinkedList<ServiceAssembly>();
        for (ArtifactClassLoader serviceArtifactClassLoader : this.serviceArtifactClassLoaders) {
            try {
                Object serviceDescriptor = serviceArtifactClassLoader.getClass().getMethod("getArtifactDescriptor", new Class[0]).invoke((Object)serviceArtifactClassLoader, new Object[0]);
                ClassLoader classLoader = (ClassLoader)serviceArtifactClassLoader.getClass().getMethod("getClassLoader", new Class[0]).invoke((Object)serviceArtifactClassLoader, new Object[0]);
                List contractModels = (List)serviceDescriptor.getClass().getMethod("getContractModels", new Class[0]).invoke(serviceDescriptor, new Object[0]);
                String name = (String)serviceDescriptor.getClass().getMethod("getName", new Class[0]).invoke(serviceDescriptor, new Object[0]);
                for (Object contract : contractModels) {
                    String serviceProviderClassName = (String)contract.getClass().getMethod("getServiceProviderClassName", new Class[0]).invoke(contract, new Object[0]);
                    String contractClassName = (String)contract.getClass().getMethod("getContractClassName", new Class[0]).invoke(contract, new Object[0]);
                    ServiceProvider serviceProvider = this.instantiateServiceProvider(classLoader, serviceProviderClassName);
                    locators.add((ServiceAssembly)new ImmutableServiceAssembly(name, serviceProvider, classLoader, Class.forName(contractClassName, true, this.getClass().getClassLoader())));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't discover service from class loader: " + String.valueOf(serviceArtifactClassLoader), e);
            }
        }
        return locators;
    }

    private ServiceProvider instantiateServiceProvider(ClassLoader classLoader, String className) throws ServiceResolutionError {
        return (ServiceProvider)ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> MuleServiceModelLoader.doInstantiateServiceProvider((String)className));
    }
}

