/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutorGenerator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Threads;

@Threads(value=3)
public class ReflectiveMethodBenchmark
extends AbstractBenchmark {
    private Target target;
    private Method method;

    @Setup
    public void setUp() throws NoSuchMethodException, SecurityException {
        this.target = new Target();
        this.method = this.target.getClass().getDeclaredMethod("doIt", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    }

    @Benchmark
    public Object reflectionCall() {
        try {
            return this.method.invoke((Object)this.target, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public Object generated() throws Exception {
        ArgumentResolverDelegate resolverDelegate = new ArgumentResolverDelegate(){
            private static final int COUNT = 10;

            public ArgumentResolver<?>[] getArgumentResolvers() {
                ArgumentResolver[] resolvers = new ArgumentResolver[10];
                for (int i = 0; i < 10; ++i) {
                    int retVal = i;
                    resolvers[i] = executionContext -> retVal;
                }
                return resolvers;
            }

            public Object[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
                Object[] values = new Object[10];
                for (int i = 0; i < 10; ++i) {
                    values[i] = i;
                }
                return values;
            }

            public Supplier<Object>[] resolveDeferred(ExecutionContext executionContext, Class<?>[] parameterTypes) {
                Supplier[] suppliers = new Supplier[10];
                for (int i = 0; i < 10; ++i) {
                    int retVal = i;
                    suppliers[i] = () -> retVal;
                }
                return suppliers;
            }
        };
        MethodExecutor executor = new MethodExecutorGenerator().generate((Object)this.target, this.method, resolverDelegate);
        return executor.execute(new ExecutionContext(){

            public boolean hasParameter(String parameterName) {
                return false;
            }

            public Object getParameter(String parameterName) {
                return null;
            }

            public Object getParameterOrDefault(String parameterName, Object defaultValue) {
                return null;
            }

            public Map<String, Object> getParameters() {
                return null;
            }

            public Optional<ConfigurationInstance> getConfiguration() {
                return Optional.empty();
            }

            public ExtensionModel getExtensionModel() {
                return null;
            }

            public ComponentModel getComponentModel() {
                return null;
            }
        });
    }

    private static class Target {
        private Target() {
        }

        public int doIt(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
            return arg0 + arg1 + arg2 + arg3 + arg4 + arg5 + arg6 + arg7 + arg8 + arg9;
        }
    }
}

