/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.TearDown;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class BindingContextBenchmark
extends AbstractBenchmark {
    private static final CoreEvent event = CoreEvent.builder((EventContext)EventContextFactory.create((String)"", (String)"", (ComponentLocation)CONNECTOR_LOCATION, null, Optional.empty())).message(Message.of((Object)PAYLOAD)).addVariable("foo", (Object)"bar").build();
    private static final BindingContext globalCtx = BindingContext.builder().addBinding("onParent", new TypedValue((Object)"hello!", DataType.STRING)).build();
    private static final BindingContext childCtx = BindingContext.builder((BindingContext)globalCtx).addBinding("onChild", new TypedValue((Object)"hello!", DataType.STRING)).build();
    private static final BindingContext bctx = event.asBindingContext();

    @TearDown
    public void teardown() throws MuleException {
    }

    @Benchmark
    public Object fromEvent() {
        return BindingContextUtils.addEventBindings((Event)event, (BindingContext)BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Benchmark
    public Object withParent() {
        return BindingContext.builder((BindingContext)globalCtx).addBinding("onChild", new TypedValue((Object)"hello!", DataType.STRING)).build();
    }

    @Benchmark
    public Object addAllThreeTimes() {
        return BindingContext.builder((BindingContext)globalCtx).addAll(childCtx).addAll(event.asBindingContext()).build();
    }

    @Benchmark
    public Object payloadBinding() {
        return bctx.lookup("payload");
    }

    @Benchmark
    public Object varsBinding() {
        return bctx.lookup("vars");
    }

    @Benchmark
    public Object threeBindings() {
        return Arrays.asList(bctx.lookup("payload"), bctx.lookup("attributes"), bctx.lookup("vars"));
    }

    @Benchmark
    public Object fiveBindings() {
        return Arrays.asList(bctx.lookup("payload"), bctx.lookup("attributes"), bctx.lookup("vars"), bctx.lookup("error"), bctx.lookup("correlationId"));
    }

    @Benchmark
    public Object parentLookup() {
        return childCtx.lookup("onParent");
    }
}

