/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public abstract class AbstractBenchmarkAssertionTestCase
extends AbstractMuleTestCase {
    private static final String ENABLE_PERFORMANCE_TESTS_SYSTEM_PROPERTY = "enablePerformanceTests";
    private static final String NORM_ALLOCATION_RESULT_KEY = "\u00b7gc.alloc.rate.norm";

    public int getTestTimeoutSecs() {
        return 300;
    }

    protected void runAndAssertBenchmark(Class clazz, String testName, double expectedResult, TimeUnit timeUnit) {
        this.runAndAssertBenchmark(clazz, testName, 1, expectedResult, timeUnit);
    }

    protected void runAndAssertBenchmark(Class clazz, String testName, double expectedResult, TimeUnit timeUnit, double expectedAllocation) {
        this.runAndAssertBenchmark(clazz, testName, 1, (Map<String, String[]>)Collections.EMPTY_MAP, expectedResult, timeUnit, expectedAllocation);
    }

    protected void runAndAssertBenchmark(Class clazz, String testName, int threads, double expectedResult, TimeUnit timeUnit) {
        this.runAndAssertBenchmark(clazz, testName, threads, (Map<String, String[]>)Collections.EMPTY_MAP, timeUnit, false, runResult -> Assert.assertThat((Object)runResult.getPrimaryResult().getScore(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(expectedResult))));
    }

    protected void runAndAssertBenchmark(Class clazz, String testName, int threads, Map<String, String[]> params, double expectedResult, TimeUnit timeUnit, double expectedAllocation) {
        this.runAndAssertBenchmark(clazz, testName, threads, params, timeUnit, true, runResult -> {
            Assert.assertThat((Object)runResult.getPrimaryResult().getScore(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(expectedResult)));
            Assert.assertThat((Object)((Result)runResult.getSecondaryResults().get(NORM_ALLOCATION_RESULT_KEY)).getScore(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(expectedAllocation)));
        });
    }

    protected void runAndAssertBenchmark(Class clazz, String testName, int threads, Map<String, String[]> params, TimeUnit timeUnit, boolean profileGC, Consumer<RunResult> assertions) {
        try {
            if (Boolean.getBoolean(ENABLE_PERFORMANCE_TESTS_SYSTEM_PROPERTY)) {
                ChainedOptionsBuilder optionsBuilder = this.createCommonOptionsBuilder(clazz, testName, params, timeUnit, profileGC);
                optionsBuilder = optionsBuilder.forks(1).threads(threads).warmupIterations(10).measurementIterations(10);
                assertions.accept(new Runner(optionsBuilder.build()).runSingle());
            } else {
                ChainedOptionsBuilder optionsBuilder = this.createCommonOptionsBuilder(clazz, testName, params, timeUnit, profileGC);
                optionsBuilder = optionsBuilder.forks(0).warmupIterations(0).measurementIterations(1);
                new Runner(optionsBuilder.build()).runSingle();
            }
        }
        catch (RunnerException e) {
            Assert.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }

    private ChainedOptionsBuilder createCommonOptionsBuilder(Class clazz, String testName, Map<String, String[]> params, TimeUnit timeUnit, boolean profileGC) {
        OptionsBuilder optionsBuilder = new OptionsBuilder();
        optionsBuilder = optionsBuilder.include(clazz.getSimpleName() + "." + testName + "$").timeUnit(timeUnit);
        if (profileGC) {
            optionsBuilder = optionsBuilder.addProfiler(GCProfiler.class);
        }
        for (Map.Entry<String, String[]> entries : params.entrySet()) {
            optionsBuilder = optionsBuilder.param(entries.getKey(), entries.getValue());
        }
        return optionsBuilder;
    }
}

