/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.mule.BasicRuntimeServicesConfigurationBuilder;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fork(value=1)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
public class AbstractBenchmark {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBenchmark.class);
    public static final String CONNECTOR_NAME = "test";
    public static final String FLOW_NAME = "flow";
    public static final String PAYLOAD;
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final ComponentLocation CONNECTOR_LOCATION;

    protected MuleContext createMuleContextWithServices() throws MuleException {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<Object> builderList = new ArrayList<Object>();
        builderList.add(new SimpleConfigurationBuilder(this.getStartUpRegistryObjects()));
        builderList.add((Object)new BasicRuntimeServicesConfigurationBuilder());
        builderList.add(ConfigurationBuilder.getMinimalConfigurationBuilder());
        builderList.addAll(this.getAdditionalConfigurationBuilders());
        return muleContextFactory.createMuleContext(builderList.toArray(new ConfigurationBuilder[0]));
    }

    protected Flow createFlow(MuleContext muleContext) {
        Flow flow = Flow.builder((String)FLOW_NAME, (MuleContext)muleContext).build();
        flow.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.from((String)FLOW_NAME)));
        return flow;
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return new HashMap<String, Object>();
    }

    protected List<ConfigurationBuilder> getAdditionalConfigurationBuilders() {
        return Collections.emptyList();
    }

    public CoreEvent createEvent(Flow flow) {
        return this.createEvent(flow, PAYLOAD);
    }

    public CoreEvent createEvent(Flow flow, Object payload) {
        try {
            return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)CONNECTOR_LOCATION)).message(Message.of((Object)payload)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        CONNECTOR_LOCATION = DefaultComponentLocation.from((String)CONNECTOR_NAME);
        try {
            PAYLOAD = IOUtils.toString((InputStream)AbstractBenchmark.class.getClassLoader().getResourceAsStream("test-data.json"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

