/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=20)
@Measurement(iterations=100)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class SdkInternalContextBenchmark
extends AbstractBenchmark {
    @Benchmark
    @Threads(value=3)
    public void contextWith3Parallel(ContextContainer ctx) {
        ComponentLocation location = DefaultComponentLocation.from((String)("comp/" + Thread.currentThread().getId()));
        for (int i = 0; i < 100; ++i) {
            String id = "" + i;
            ctx.ctx.putContext(location, id);
            ctx.ctx.setConfiguration(location, id, Optional.empty());
            ctx.ctx.removeContext(location, id);
        }
    }

    @Benchmark
    @Threads(value=300)
    public void contextWith300ParallelChildren(ContextContainer ctx) {
        ComponentLocation location = DefaultComponentLocation.from((String)("comp/" + Thread.currentThread().getId()));
        for (int i = 0; i < 100; ++i) {
            String id = "" + i;
            ctx.ctx.putContext(location, id);
            ctx.ctx.setConfiguration(location, id, Optional.empty());
            ctx.ctx.removeContext(location, id);
        }
    }

    @State(value=Scope.Benchmark)
    public static class ContextContainer {
        SdkInternalContext ctx;

        @Setup(value=Level.Iteration)
        public void setUp() {
            this.ctx = new SdkInternalContext();
        }
    }
}

