/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.metrics;

import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.metrics.AbstractOpenTelemetryMetricsTestCase;
import org.mule.test.components.metrics.export.ExportedMeter;

public abstract class AbstractOpenTelemetryFlowStatisticsSummaryTestCase
extends AbstractOpenTelemetryMetricsTestCase {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;

    @Test
    public void test() {
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                try {
                    AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.verifyMetricsExists("declared-private-flows", "Declared Private Flows", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getResourceName(), "flows-summary-statistic", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getExpectedDeclaredPrivateFlows(), AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics());
                    AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.verifyMetricsExists("active-private-flows", "Activate Private Flows", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getResourceName(), "flows-summary-statistic", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getExpectedActivePrivateFlows(), AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics());
                    AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.verifyMetricsExists("declared-apikit-flows", "Declared ApiKit Flows", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getResourceName(), "flows-summary-statistic", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getExpectedDeclaredApikitFlows(), AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics());
                    AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.verifyMetricsExists("active-apikit-flows", "Active Apikit Flows", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getResourceName(), "flows-summary-statistic", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getExpectedActiveApikitFlows(), AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics());
                    AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.verifyMetricsExists("declared-trigger-flows", "Declared Trigger Flows", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getResourceName(), "flows-summary-statistic", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getExpectedDeclaredTriggerFlows(), AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics());
                    AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.verifyMetricsExists("active-trigger-flows", "Active Trigger Flows", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getResourceName(), "flows-summary-statistic", AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.getExpectedActiveTriggerFlows(), AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics());
                }
                catch (Throwable e) {
                    return false;
                }
                return true;
            }

            public String describeFailure() {
                return "Error on verifying metrics: " + this.getShowStatsInfo();
            }

            private String getShowStatsInfo() {
                StringBuffer statsInfo = new StringBuffer();
                AbstractOpenTelemetryFlowStatisticsSummaryTestCase.this.server.getMetrics().forEach(metric -> statsInfo.append(metric.getName()).append(": ").append(metric.getValue()).append(System.lineSeparator()));
                return statsInfo.toString();
            }
        });
    }

    private void verifyMetricsExists(String metricName, String description, String resourceName, String instrumentationName, long expectedValue, List<ExportedMeter> metrics) {
        List exportedMetersForMetric = metrics.stream().filter(metric -> metric.getName().equals(metricName)).collect(Collectors.toList());
        Assert.assertThat(exportedMetersForMetric, (Matcher)Matchers.hasSize((int)1));
        ExportedMeter exportedMeter = (ExportedMeter)exportedMetersForMetric.get(0);
        Assert.assertThat((Object)exportedMeter.getName(), (Matcher)Matchers.equalTo((Object)metricName));
        Assert.assertThat((Object)exportedMeter.getDescription(), (Matcher)Matchers.equalTo((Object)description));
        Assert.assertThat((Object)exportedMeter.getResourceName(), (Matcher)Matchers.equalTo((Object)resourceName));
        Assert.assertThat((Object)exportedMeter.getInstrumentName(), (Matcher)Matchers.equalTo((Object)instrumentationName));
        Assert.assertThat((Object)exportedMeter.getValue(), (Matcher)Matchers.equalTo((Object)expectedValue));
    }

    abstract String getResourceName();

    abstract long getExpectedDeclaredPrivateFlows();

    abstract long getExpectedDeclaredApikitFlows();

    abstract long getExpectedDeclaredTriggerFlows();

    abstract long getExpectedActivePrivateFlows();

    abstract long getExpectedActiveApikitFlows();

    abstract long getExpectedActiveTriggerFlows();
}

