/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.metrics;

import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.protocol.AbstractUnaryGrpcService;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.test.components.metrics.OpenTelemetryMetricsTestRunnerConfigAnnotation;
import org.mule.test.components.metrics.export.ExportedMeter;
import org.mule.test.components.metrics.export.OpenTelemetryMetricsTestUtils;

public abstract class AbstractOpenTelemetryMetricsTestCase
extends MuleArtifactFunctionalTestCase
implements OpenTelemetryMetricsTestRunnerConfigAnnotation {
    private static final String EXPORTER_CONF_FILE = "conf/meter-exporter.conf";
    @Rule
    public final TestGrpcServerRule server = new TestGrpcServerRule();

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        System.setProperty("mule.enable.statistics", Boolean.TRUE.toString());
        System.setProperty("mule.open.telemetry.metric.exporter", Boolean.TRUE.toString());
        Path configurationFilePath = Path.of(Thread.currentThread().getContextClassLoader().getResource(EXPORTER_CONF_FILE).toURI());
        System.setProperty("mule.openTelemetry.meter.exporter.configurationFilePath", configurationFilePath.getParent().toString());
        System.setProperty("mule.openTelemetry.meter.exporter.enabled", Boolean.TRUE.toString());
        System.setProperty("mule.openTelemetry.meter.exporter.endpoint", "http://localhost:" + this.server.httpPort());
    }

    @After
    public void after() {
        System.clearProperty("mule.enable.statistics");
        System.clearProperty("mule.open.telemetry.metric.exporter");
        System.clearProperty("mule.openTelemetry.meter.exporter.configurationFilePath");
        System.clearProperty("mule.openTelemetry.meter.exporter.enabled");
        System.clearProperty("mule.openTelemetry.meter.exporter.endpoint");
        this.server.reset();
    }

    protected void verifyMetricsExists(String metricName, String description, String resourceName, String instrumentationName, long expectedValue, List<ExportedMeter> metrics) {
        List exportedMetersForMetric = metrics.stream().filter(metric -> metric.getName().equals(metricName)).collect(Collectors.toList());
        Assert.assertThat(exportedMetersForMetric, (Matcher)Matchers.hasSize((int)1));
        ExportedMeter exportedMeter = (ExportedMeter)exportedMetersForMetric.get(0);
        Assert.assertThat((Object)exportedMeter.getName(), (Matcher)Matchers.equalTo((Object)metricName));
        Assert.assertThat((Object)exportedMeter.getDescription(), (Matcher)Matchers.equalTo((Object)description));
        Assert.assertThat((Object)exportedMeter.getResourceName(), (Matcher)Matchers.equalTo((Object)resourceName));
        Assert.assertThat((Object)exportedMeter.getInstrumentName(), (Matcher)Matchers.equalTo((Object)instrumentationName));
        Assert.assertThat((Object)exportedMeter.getValue(), (Matcher)Matchers.equalTo((Object)expectedValue));
    }

    protected static final class TestGrpcServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/opentelemetry.proto.collector.metrics.v1.MetricsService/Export";
        private List<ExportedMeter> metrics;

        protected TestGrpcServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractUnaryGrpcService(){

                @NotNull
                protected CompletionStage<byte[]> handleMessage(@NotNull ServiceRequestContext ctx, byte @NotNull [] message) {
                    try {
                        if (metrics == null) {
                            metrics = OpenTelemetryMetricsTestUtils.getMetrics(ExportMetricsServiceRequest.parseFrom((byte[])message));
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new UncheckedIOException((IOException)((Object)e));
                    }
                    return CompletableFuture.completedFuture(ExportTraceServiceResponse.getDefaultInstance().toByteArray());
                }
            });
            sb.http(0);
        }

        public List<ExportedMeter> getMetrics() {
            return this.metrics == null ? Collections.emptyList() : this.metrics;
        }

        public void reset() {
            this.metrics = null;
        }
    }
}

