/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class FlowAsyncBeforeAfterOutboundTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-async-before-after-outbound.xml";
    }

    @Test
    public void testAsyncBefore() throws Exception {
        Message msgSync = ((FlowRunner)this.flowRunner("test-async-block-before-outbound").withPayload((Object)"message")).run().getMessage();
        Message msgAsync = this.queueManager.read("test.before.async.out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Message msgOut = this.queueManager.read("test.before.out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        this.assertCorrectThreads(msgSync, msgAsync, msgOut);
    }

    @Test
    public void testAsyncAfter() throws Exception {
        Message msgSync = ((FlowRunner)this.flowRunner("test-async-block-after-outbound").withPayload((Object)"message")).run().getMessage();
        Message msgAsync = this.queueManager.read("test.after.async.out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Message msgOut = this.queueManager.read("test.after.out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        this.assertCorrectThreads(msgSync, msgAsync, msgOut);
    }

    private void assertCorrectThreads(Message msgSync, Message msgAsync, Message msgOut) throws Exception {
        Assert.assertThat((Object)msgSync, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)msgAsync, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)msgOut, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)msgOut.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)msgSync.getPayload().getValue()));
        Assert.assertThat((Object)msgSync.getPayload().getValue(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)msgAsync.getPayload().getValue())));
        Assert.assertThat((Object)msgOut.getPayload().getValue(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)msgAsync.getPayload().getValue())));
        Assert.assertThat((Object)((String)msgAsync.getPayload().getValue()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ring-buffer")));
    }

    public static class ThreadSensingMessageProcessor
    implements Processor {
        private static final ThreadLocal<String> taskTokenInThread = new ThreadLocal();
        private static final AtomicInteger idgenerator = new AtomicInteger();

        public CoreEvent process(CoreEvent event) throws MuleException {
            String requestTaskToken;
            if (taskTokenInThread.get() != null) {
                requestTaskToken = taskTokenInThread.get();
            } else {
                requestTaskToken = this.generateTaskToken();
                taskTokenInThread.set(requestTaskToken);
            }
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).payload(new TypedValue((Object)requestTaskToken, DataType.STRING)).build()).build();
        }

        protected String generateTaskToken() {
            return Thread.currentThread().getName() + " - " + idgenerator.getAndIncrement();
        }
    }
}

