/*
 * Decompiled with CFR 0.152.
 */
package org.mule.http.server;

import io.qameta.allure.Feature;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP Service")
public class MethodRequestMatcherTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HttpRequestBuilder requestBuilder = HttpRequest.builder().uri("uri");

    @Test
    public void cannotBeEmpty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("methods attribute should not be empty");
        MethodRequestMatcher.builder().build();
    }

    @Test
    public void cannotBeEmptyCollection() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("methods attribute should not be empty");
        MethodRequestMatcher.builder(new LinkedList()).build();
    }

    @Test
    public void cannotBeNullCollection() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("methods attribute should not be null");
        MethodRequestMatcher.builder(null).build();
    }

    @Test
    public void cannotBeNullString() {
        String none = null;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("method attribute should not be null");
        MethodRequestMatcher.builder().add(none);
    }

    @Test
    public void cannotBeNullMethod() {
        HttpConstants.Method none = null;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("method attribute should not be null");
        MethodRequestMatcher.builder().add(none);
    }

    @Test
    public void onlyAcceptsOneMethod() {
        MethodRequestMatcher matcher = MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build();
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.method(HttpConstants.Method.GET).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.method(HttpConstants.Method.POST).build()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void acceptSeveralMethods() {
        MethodRequestMatcher matcher = MethodRequestMatcher.builder().add(HttpConstants.Method.GET).add(HttpConstants.Method.POST).add(HttpConstants.Method.PATCH).build();
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.method(HttpConstants.Method.GET).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.method(HttpConstants.Method.POST).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.method(HttpConstants.Method.PATCH).build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(this.requestBuilder.method(HttpConstants.Method.OPTIONS).build()), (Matcher)Is.is((Object)false));
    }
}

