/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers.specific;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.notification.SecurityNotificationListener;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.UnauthorisedException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.ServerNotificationConfigurationChangeListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

public class ServerNotificationManagerTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private ServerNotificationManager manager;
    @Inject
    private TestListener listener;
    @Inject
    @Named(value="listener2")
    private TestListener2 listener2;
    @Inject
    @Named(value="listener3")
    private TestListener2 listener3;
    @Inject
    @Named(value="listener4")
    private TestListener2 listener4;
    @Inject
    @Named(value="listener5")
    private TestListener2 listener5;
    @Inject
    private TestSecurityListener securityListener;

    protected String getConfigFile() {
        return "org/mule/config/spring/parsers/specific/server-notification-manager-test.xml";
    }

    @Test
    public void testDynamicAttribute() {
        MatcherAssert.assertThat((Object)this.manager.isNotificationDynamic(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRoutingConfiguration() {
        MatcherAssert.assertThat(this.manager.getInterfaceToTypes().entrySet(), (Matcher)IsCollectionWithSize.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2))));
        Object ifaces = this.manager.getInterfaceToTypes().get(TestInterface.class);
        MatcherAssert.assertThat(ifaces, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(ifaces, (Matcher)Matchers.instanceOf(Collection.class));
        MatcherAssert.assertThat((Object)((Collection)ifaces), (Matcher)IsIterableContaining.hasItem(TestEvent.class));
        ifaces = this.manager.getInterfaceToTypes().get(TestInterface2.class);
        MatcherAssert.assertThat(ifaces, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(ifaces, (Matcher)Matchers.instanceOf(Collection.class));
        MatcherAssert.assertThat((Object)((Collection)ifaces), (Matcher)IsIterableContaining.hasItem(SecurityNotification.class));
    }

    @Test
    public void testSimpleNotification() throws InterruptedException {
        Set listeners = this.manager.getListeners();
        MatcherAssert.assertThat((Object)listeners, (Matcher)IsCollectionWithSize.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5))));
        MatcherAssert.assertThat((Object)this.listener, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.listener.isCalled(), (Matcher)Matchers.is((Object)false));
        this.manager.fireNotification((Notification)new TestEvent());
        new PollingProber(1000L, 50L).check((Probe)new JUnitLambdaProbe(() -> this.listener.isCalled()));
    }

    @Test
    public void testExplicitlyConiguredNotificationListenerRegistration() throws InterruptedException {
        MatcherAssert.assertThat((Object)this.manager.getListeners(), (Matcher)IsIterableContaining.hasItem((Matcher)ServerNotificationManagerTestCase.withListener(this.listener)));
        MatcherAssert.assertThat((Object)this.manager.getListeners(), (Matcher)IsIterableContaining.hasItem((Matcher)ServerNotificationManagerTestCase.withListener(this.listener2)));
        MatcherAssert.assertThat((Object)this.manager.getListeners(), (Matcher)IsIterableContaining.hasItem((Matcher)ServerNotificationManagerTestCase.withListener((NotificationListener)this.securityListener)));
        MatcherAssert.assertThat((Object)this.manager.getListeners(), (Matcher)IsIterableContaining.hasItem((Matcher)Matchers.allOf((Matcher)ServerNotificationManagerTestCase.withListener(this.listener3), (Matcher)ServerNotificationManagerTestCase.withNoSubscription())));
        MatcherAssert.assertThat((Object)this.manager.getListeners(), (Matcher)IsIterableContaining.hasItem((Matcher)Matchers.allOf((Matcher)ServerNotificationManagerTestCase.withListener(this.listener5), (Matcher)ServerNotificationManagerTestCase.withSubscriptionOnlyFor("customResource"))));
    }

    @Test
    public void testAdhocNotificationListenerRegistrations() throws InterruptedException {
        MatcherAssert.assertThat((Object)this.manager.getListeners(), (Matcher)IsIterableContaining.hasItem((Matcher)ServerNotificationManagerTestCase.withListener(this.listener4)));
    }

    @Test
    public void testDisabledNotification() throws Exception {
        Set listeners = this.manager.getListeners();
        MatcherAssert.assertThat((Object)listeners, (Matcher)IsCollectionWithSize.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5))));
        MatcherAssert.assertThat((Object)this.listener2, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.listener2.isCalled(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.securityListener, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.securityListener.isCalled(), (Matcher)Matchers.is((Object)false));
        this.manager.fireNotification((Notification)new TestSecurityEvent(muleContext));
        new PollingProber(2000L, 100L).check((Probe)new JUnitLambdaProbe(() -> this.listener2.isCalled(), "listener2 should be notified"));
        MatcherAssert.assertThat((Object)this.securityListener.isCalled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testServerNotificationConfigurationChangeListenerTestCase() throws Exception {
        ServerNotificationConfigurationChangeListener serverNotificationConfigurationChangeListener = (ServerNotificationConfigurationChangeListener)Mockito.mock(ServerNotificationConfigurationChangeListener.class);
        this.manager.registerServerNotificationConfigurationChangeListener(serverNotificationConfigurationChangeListener);
        this.manager.addInterfaceToType(TestInterface.class, Notification.class);
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)1))).onServerNotificationConfigurationChange();
        this.manager.setInterfaceToTypes((Map)Mockito.mock(Map.class));
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)2))).onServerNotificationConfigurationChange();
        this.manager.addListener((NotificationListener)Mockito.mock(NotificationListener.class));
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)3))).onServerNotificationConfigurationChange();
        this.manager.addListenerSubscriptionPair(new ListenerSubscriptionPair((NotificationListener)Mockito.mock(NotificationListener.class)));
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)4))).onServerNotificationConfigurationChange();
        this.manager.addListenerSubscription((NotificationListener)Mockito.mock(NotificationListener.class), (Predicate)Mockito.mock(Predicate.class));
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)5))).onServerNotificationConfigurationChange();
        this.manager.removeListener((NotificationListener)Mockito.mock(NotificationListener.class));
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)6))).onServerNotificationConfigurationChange();
        this.manager.disableInterface(TestInterface.class);
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)7))).onServerNotificationConfigurationChange();
        this.manager.setDisabledInterfaces(Set.of(TestInterface.class));
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)8))).onServerNotificationConfigurationChange();
        this.manager.disableType(Notification.class);
        ((ServerNotificationConfigurationChangeListener)Mockito.verify((Object)serverNotificationConfigurationChangeListener, (VerificationMode)Mockito.times((int)9))).onServerNotificationConfigurationChange();
    }

    public static ListenerSubscriptionPairMatcher withListener(NotificationListener listener) {
        return new ListenerSubscriptionPairMatcher(Matchers.sameInstance((Object)listener), null);
    }

    public static ListenerSubscriptionPairMatcher withSubscriptionOnlyFor(Object subscription) {
        return new ListenerSubscriptionPairMatcher(null, subscription);
    }

    public static ListenerSubscriptionPairMatcher withNoSubscription() {
        return new ListenerSubscriptionPairMatcher(null, null);
    }

    protected static interface TestInterface
    extends NotificationListener<TestEvent> {
    }

    protected static class TestEvent
    extends AbstractServerNotification {
        public TestEvent() {
            super(new Object(), Integer.MIN_VALUE);
        }

        public String getEventName() {
            return "TestEvent";
        }
    }

    protected static interface TestInterface2
    extends NotificationListener<Notification> {
    }

    public static class TestListener
    implements TestInterface {
        private boolean called = false;

        public boolean isCalled() {
            return this.called;
        }

        public void onNotification(TestEvent notification) {
            this.called = true;
        }
    }

    private static class ListenerSubscriptionPairMatcher<N extends Notification>
    extends TypeSafeMatcher<ListenerSubscriptionPair<N>> {
        private final Matcher<NotificationListener<N>> listenerMatcher;
        private final Object subscription;

        public ListenerSubscriptionPairMatcher(Matcher<NotificationListener<N>> listenerMatcher, Object subscription) {
            this.listenerMatcher = listenerMatcher;
            this.subscription = subscription;
        }

        public void describeTo(Description description) {
            if (this.listenerMatcher != null) {
                description.appendText("listener ");
                this.listenerMatcher.describeTo(description);
            }
            if (this.subscription != null) {
                description.appendText("subscription for " + this.subscription.toString());
            }
        }

        protected boolean matchesSafely(ListenerSubscriptionPair<N> item) {
            boolean match = true;
            if (this.listenerMatcher != null) {
                boolean bl = match = match && this.listenerMatcher.matches((Object)item.getListener());
            }
            if (this.subscription != null) {
                AbstractServerNotification mockNotificationMatches = (AbstractServerNotification)Mockito.mock(AbstractServerNotification.class);
                Mockito.when((Object)mockNotificationMatches.getResourceIdentifier()).thenReturn((Object)this.subscription.toString());
                match = match && item.getSelector().test(mockNotificationMatches);
                AbstractServerNotification mockNotificationNotMatches = (AbstractServerNotification)Mockito.mock(AbstractServerNotification.class);
                Mockito.when((Object)mockNotificationNotMatches.getResourceIdentifier()).thenReturn((Object)"");
                match = match && !item.getSelector().test(mockNotificationNotMatches);
            }
            return match;
        }
    }

    public static class TestListener2
    implements TestInterface2 {
        private boolean called = false;

        public boolean isCalled() {
            return this.called;
        }

        public void onNotification(Notification notification) {
            this.called = true;
        }
    }

    public static class TestSecurityListener
    implements SecurityNotificationListener<SecurityNotification> {
        private boolean called = false;

        public boolean isCalled() {
            return this.called;
        }

        public boolean isBlocking() {
            return false;
        }

        public void onNotification(SecurityNotification notification) {
            this.called = true;
        }
    }

    protected static class TestSecurityEvent
    extends SecurityNotification {
        public boolean isSynchronous() {
            return true;
        }

        public TestSecurityEvent(MuleContext muleContext) throws Exception {
            super((SecurityException)new UnauthorisedException(I18nMessageFactory.createStaticMessage((String)"dummy")), Integer.MIN_VALUE);
        }

        public String getEventName() {
            return "TestSecurityEvent";
        }
    }
}

