/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
@RunnerDelegateTo(value=Parameterized.class)
public class ExpiredShutdownTimeoutOneWayTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "100");
    private final boolean runWithtinTx;

    @Parameterized.Parameters(name="tx: {0}")
    public static List<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    public ExpiredShutdownTimeoutOneWayTestCase(boolean runWithtinTx) {
        this.runWithtinTx = runWithtinTx;
    }

    protected String getConfigFile() {
        return "org/mule/shutdown/shutdown-timeout-one-way-config.xml";
    }

    @Test
    public void testStaticComponent() throws Throwable {
        this.doShutDownTest("staticComponentFlow");
    }

    @Test
    public void testScriptComponent() throws Throwable {
        this.doShutDownTest("scriptComponentFlow");
    }

    @Test
    public void testSetPayload() throws Throwable {
        this.doShutDownTest("setPayloadFlow");
    }

    @Test
    public void testSetPayloadChoice() throws Throwable {
        this.doShutDownTest("setPayloadChoiceFlow");
    }

    @Test
    public void testSetPayloadThroughScatterGatherWithFlowRefs() throws Throwable {
        this.doShutDownTest("setPayloadThroughScatterGatherWithFlowRefs");
    }

    private void doShutDownTest(String flowName) throws Throwable {
        Future<?> requestTask = this.executor.submit(() -> {
            try {
                FlowRunner runner = (FlowRunner)this.flowRunner(flowName).withPayload((Object)"Test Message");
                if (this.runWithtinTx) {
                    Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
                    runner = runner.transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, transaction);
                }
                runner.dispatch();
                MatcherAssert.assertThat((String)"Was able to process message ", (Object)this.queueManager.read("response", 5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        waitLatch.await();
        muleContext.stop();
        contextStopLatch.release();
        try {
            requestTask.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

