/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification.processors;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.core.context.notification.processors.ProcessorNotificationStore;

@Feature(value="Configuration component locator")
@Story(value="Component location")
public class ComponentLocationTestCase
extends AbstractIntegrationTestCase {
    private static final Optional<TypedComponentIdentifier> FLOW_TYPED_COMPONENT_IDENTIFIER = Optional.of(TypedComponentIdentifier.builder().identifier(CoreDslConstants.FLOW_IDENTIFIER).type(TypedComponentIdentifier.ComponentType.FLOW).build());
    private static final Optional<TypedComponentIdentifier> SUB_FLOW_TYPED_COMPONENT_IDENTIFIER = Optional.of(TypedComponentIdentifier.builder().identifier(CoreDslConstants.SUBFLOW_IDENTIFIER).type(TypedComponentIdentifier.ComponentType.SUB_FLOW).build());
    private static final Optional<String> CONFIG_FILE_NAME = Optional.of("org/mule/test/integration/notifications/component-path-test-flow.xml");
    private static final DefaultComponentLocation FLOW_WITH_SINGLE_MP_LOCATION = new DefaultComponentLocation(Optional.of("flowWithSingleMp"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithSingleMp", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(27), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_MULTIPLE_MP_LOCATION = new DefaultComponentLocation(Optional.of("flowWithMultipleMps"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithMultipleMps", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(31), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_ERROR_HANDLER = new DefaultComponentLocation(Optional.of("flowWithErrorHandler"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithErrorHandler", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(37), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_BLOCK_WITH_ERROR_HANDLER = new DefaultComponentLocation(Optional.of("flowWithTryWithErrorHandler"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithTryWithErrorHandler", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(58), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_SOURCE = new DefaultComponentLocation(Optional.of("flowWithSource"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithSource", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(70), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_SCATTER_GATHER = new DefaultComponentLocation(Optional.of("flowWithScatterGather"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithScatterGather", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(90), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_ASYNC = new DefaultComponentLocation(Optional.of("flowWithAsync"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithAsync", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(104), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_SUBFLOW = new DefaultComponentLocation(Optional.of("flowWithSubflow"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flowWithSubflow", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(79), OptionalInt.of(5))));
    private static final DefaultComponentLocation SUBFLOW = new DefaultComponentLocation(Optional.of("subflow"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("subflow", SUB_FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(85), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_AGGREGATOR_ONE_ROUTE = new DefaultComponentLocation(Optional.of("aggregatorWithOneRoute"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("aggregatorWithOneRoute", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(117), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_AGGREGATOR_TWO_ROUTES = new DefaultComponentLocation(Optional.of("aggregatorWithTwoRoutes"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("aggregatorWithTwoRoutes", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(125), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_AGGREGATOR_TWO_ROUTES_AND_CONTENT = new DefaultComponentLocation(Optional.of("aggregatorWithTwoRoutesAndContent"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("aggregatorWithTwoRoutesAndContent", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(136), OptionalInt.of(5))));
    private static final DefaultComponentLocation FLOW_WITH_OPERATION_WITH_CHAIN = new DefaultComponentLocation(Optional.of("operationWithChain"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("operationWithChain", FLOW_TYPED_COMPONENT_IDENTIFIER, CONFIG_FILE_NAME, OptionalInt.of(148), OptionalInt.of(5))));
    private static final Optional<TypedComponentIdentifier> LOGGER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:logger")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> SET_PAYLOAD = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:set-payload")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> SET_VARIABLE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:set-variable")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> CHOICE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:choice")).type(TypedComponentIdentifier.ComponentType.ROUTER).build());
    private static final Optional<TypedComponentIdentifier> WHEN = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:when")).type(TypedComponentIdentifier.ComponentType.ROUTE).build());
    private static final Optional<TypedComponentIdentifier> ERROR_HANDLER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:error-handler")).type(TypedComponentIdentifier.ComponentType.ERROR_HANDLER).build());
    private static final Optional<TypedComponentIdentifier> ON_ERROR_CONTINUE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:on-error-continue")).type(TypedComponentIdentifier.ComponentType.ON_ERROR).build());
    private static final Optional<TypedComponentIdentifier> VALIDATION_IS_FALSE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"validation:is-false")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> RAISE_ERROR = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:raise-error")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> ON_ERROR_PROPAGATE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:on-error-propagate")).type(TypedComponentIdentifier.ComponentType.ON_ERROR).build());
    private static final Optional<TypedComponentIdentifier> TRY = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:try")).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    private static final Optional<TypedComponentIdentifier> VALIDATION_IS_TRUE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"validation:is-true")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> SCHEDULER_SOURCE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:scheduler")).type(TypedComponentIdentifier.ComponentType.SOURCE).build());
    private static final Optional<TypedComponentIdentifier> SCATTER_GATHER = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:scatter-gather")).type(TypedComponentIdentifier.ComponentType.ROUTER).build());
    private static final Optional<TypedComponentIdentifier> FLOW_REF = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:flow-ref")).type(TypedComponentIdentifier.ComponentType.OPERATION).build());
    private static final Optional<TypedComponentIdentifier> ASYNC = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:async")).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    private static final Optional<TypedComponentIdentifier> ROUTE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"mule:route")).type(TypedComponentIdentifier.ComponentType.ROUTE).build());
    private static final Optional<TypedComponentIdentifier> AGGREGATOR = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"aggregators:size-based-aggregator")).type(TypedComponentIdentifier.ComponentType.ROUTER).build());
    private static final Optional<TypedComponentIdentifier> AGGREGATION_INCREMENTAL = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"aggregators:incremental-aggregation")).type(TypedComponentIdentifier.ComponentType.ROUTE).build());
    private static final Optional<TypedComponentIdentifier> AGGREGATION_COMPLETE = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"aggregators:aggregation-complete")).type(TypedComponentIdentifier.ComponentType.ROUTE).build());
    private static final Optional<TypedComponentIdentifier> TAP_PHONES = Optional.of(TypedComponentIdentifier.builder().identifier(ComponentIdentifier.buildFromStringRepresentation((String)"heisenberg:tap-phones")).type(TypedComponentIdentifier.ComponentType.SCOPE).build());
    @Inject
    @Named(value="flowWithSource")
    private Flow flowWithSource;
    @Inject
    private ConfigurationComponentLocator configurationComponentLocator;

    protected String getConfigFile() {
        return CONFIG_FILE_NAME.get();
    }

    @After
    public void clearNotifications() {
        ProcessorNotificationStore notificationsStore = this.getNotificationsStore();
        if (notificationsStore != null) {
            notificationsStore.getNotifications().clear();
        }
    }

    @Test
    public void flowWithSingleMp() throws Exception {
        this.flowRunner("flowWithSingleMp").run();
        this.assertNextProcessorLocationIs(FLOW_WITH_SINGLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(28), OptionalInt.of(9)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithMultipleMps() throws Exception {
        this.flowRunner("flowWithMultipleMps").run();
        this.assertNextProcessorLocationIs(FLOW_WITH_MULTIPLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(32), OptionalInt.of(9)));
        this.assertNextProcessorLocationIs(FLOW_WITH_MULTIPLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("1", SET_PAYLOAD, CONFIG_FILE_NAME, OptionalInt.of(33), OptionalInt.of(9)));
        this.assertNextProcessorLocationIs(FLOW_WITH_MULTIPLE_MP_LOCATION.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("2", SET_VARIABLE, CONFIG_FILE_NAME, OptionalInt.of(34), OptionalInt.of(9)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithErrorHandlerExecutingOnContinue() throws Exception {
        ((FlowRunner)this.flowRunner("flowWithErrorHandler").withVariable("executeFailingComponent", (Object)false)).run();
        DefaultComponentLocation choiceLocation = FLOW_WITH_ERROR_HANDLER.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("0", CHOICE, CONFIG_FILE_NAME, OptionalInt.of(38), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(choiceLocation);
        this.assertNextProcessorLocationIs(FLOW_WITH_ERROR_HANDLER.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, OptionalInt.of(46), OptionalInt.of(9)).appendLocationPart("0", ON_ERROR_CONTINUE, CONFIG_FILE_NAME, OptionalInt.of(47), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, OptionalInt.of(48), OptionalInt.of(17)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithErrorHandlerExecutingOnPropagate() throws Exception {
        ((FlowRunner)this.flowRunner("flowWithErrorHandler").withVariable("executeFailingComponent", (Object)true)).runExpectingException();
        DefaultComponentLocation choiceLocation = FLOW_WITH_ERROR_HANDLER.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("0", CHOICE, CONFIG_FILE_NAME, OptionalInt.of(38), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(choiceLocation);
        DefaultComponentLocation choiceRoute0 = choiceLocation.appendRoutePart().appendLocationPart("0", WHEN, CONFIG_FILE_NAME, OptionalInt.of(39), OptionalInt.of(13));
        this.assertNextProcessorLocationIs(choiceRoute0.appendProcessorsPart().appendLocationPart("0", RAISE_ERROR, CONFIG_FILE_NAME, OptionalInt.of(40), OptionalInt.of(17)));
        this.assertNextProcessorLocationIs(FLOW_WITH_ERROR_HANDLER.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, OptionalInt.of(46), OptionalInt.of(9)).appendLocationPart("1", ON_ERROR_PROPAGATE, CONFIG_FILE_NAME, OptionalInt.of(50), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", TRY, CONFIG_FILE_NAME, OptionalInt.of(51), OptionalInt.of(17)));
        this.assertNextProcessorLocationIs(FLOW_WITH_ERROR_HANDLER.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, OptionalInt.of(46), OptionalInt.of(9)).appendLocationPart("1", ON_ERROR_PROPAGATE, CONFIG_FILE_NAME, OptionalInt.of(50), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", TRY, CONFIG_FILE_NAME, OptionalInt.of(51), OptionalInt.of(17)).appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, OptionalInt.of(52), OptionalInt.of(21)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithBlockWithErrorHandler() throws Exception {
        this.flowRunner("flowWithTryWithErrorHandler").run();
        DefaultComponentLocation blockLocation = FLOW_WITH_BLOCK_WITH_ERROR_HANDLER.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("0", TRY, CONFIG_FILE_NAME, OptionalInt.of(59), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(blockLocation);
        this.assertNextProcessorLocationIs(blockLocation.appendProcessorsPart().appendLocationPart("0", RAISE_ERROR, CONFIG_FILE_NAME, OptionalInt.of(60), OptionalInt.of(13)));
        DefaultComponentLocation blockOnErrorContinueLocation = blockLocation.appendLocationPart("errorHandler", ERROR_HANDLER, CONFIG_FILE_NAME, OptionalInt.of(61), OptionalInt.of(13)).appendLocationPart("0", ON_ERROR_CONTINUE, CONFIG_FILE_NAME, OptionalInt.of(62), OptionalInt.of(17));
        this.assertNextProcessorLocationIs(blockOnErrorContinueLocation.appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, OptionalInt.of(63), OptionalInt.of(21)));
        this.assertNextProcessorLocationIs(blockOnErrorContinueLocation.appendProcessorsPart().appendLocationPart("1", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, OptionalInt.of(64), OptionalInt.of(21)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithSource() {
        DefaultComponentLocation expectedSourceLocation = FLOW_WITH_SOURCE.appendLocationPart("source", SCHEDULER_SOURCE, CONFIG_FILE_NAME, OptionalInt.of(71), OptionalInt.of(9));
        DefaultComponentLocation sourceLocation = (DefaultComponentLocation)this.flowWithSource.getSource().getAnnotation(AbstractComponent.LOCATION_KEY);
        Assert.assertThat((Object)sourceLocation, (Matcher)Is.is((Object)expectedSourceLocation));
        Assert.assertThat((Object)((Component)this.flowWithSource.getProcessors().get(0)).getAnnotation(AbstractComponent.LOCATION_KEY), (Matcher)Is.is((Object)FLOW_WITH_SOURCE.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()).appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(76), OptionalInt.of(9))));
    }

    @Test
    public void flowWithSubflow() throws Exception {
        this.flowRunner("flowWithSubflow").run();
        DefaultComponentLocation flowWithSplitterProcessorsLocation = FLOW_WITH_SUBFLOW.appendProcessorsPart();
        this.assertNextProcessorLocationIs(flowWithSplitterProcessorsLocation.appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(80), OptionalInt.of(9)));
        this.assertNextProcessorLocationIs(flowWithSplitterProcessorsLocation.appendLocationPart("1", FLOW_REF, CONFIG_FILE_NAME, OptionalInt.of(81), OptionalInt.of(9)));
        this.assertNextProcessorLocationIs(SUBFLOW.appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(86), OptionalInt.of(9)));
        this.assertNextProcessorLocationIs(SUBFLOW.appendProcessorsPart().appendLocationPart("1", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, OptionalInt.of(87), OptionalInt.of(9)));
        this.assertNextProcessorLocationIs(flowWithSplitterProcessorsLocation.appendLocationPart("2", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, OptionalInt.of(82), OptionalInt.of(9)));
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithScatterGather() throws Exception {
        this.flowRunner("flowWithScatterGather").run();
        this.waitUntilNotificationsArrived(4);
        DefaultComponentLocation flowWithSplitterProcessorsLocation = FLOW_WITH_SCATTER_GATHER.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        DefaultComponentLocation scatterGatherLocation = flowWithSplitterProcessorsLocation.appendLocationPart("0", SCATTER_GATHER, CONFIG_FILE_NAME, OptionalInt.of(91), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(scatterGatherLocation);
        DefaultComponentLocation scatterGatherRoute0 = scatterGatherLocation.appendRoutePart().appendLocationPart("0", ROUTE, CONFIG_FILE_NAME, OptionalInt.of(92), OptionalInt.of(13));
        DefaultComponentLocation scatterGatherRouter1 = scatterGatherLocation.appendRoutePart().appendLocationPart("1", ROUTE, CONFIG_FILE_NAME, OptionalInt.of(95), OptionalInt.of(13));
        DefaultComponentLocation scatterGatherRouter2 = scatterGatherLocation.appendRoutePart().appendLocationPart("2", ROUTE, CONFIG_FILE_NAME, OptionalInt.of(98), OptionalInt.of(13));
        List<DefaultComponentLocation> nextLocations = Arrays.asList(scatterGatherRoute0.appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(93), OptionalInt.of(17)), scatterGatherRouter1.appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, OptionalInt.of(96), OptionalInt.of(17)), scatterGatherRouter2.appendProcessorsPart().appendLocationPart("0", VALIDATION_IS_FALSE, CONFIG_FILE_NAME, OptionalInt.of(99), OptionalInt.of(17)));
        this.assertNextProcessorLocationsAre(nextLocations);
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void flowWithAsync() throws Exception {
        FlowRunner runner = this.flowRunner("flowWithAsync");
        CountDownLatch terminationLatch = new CountDownLatch(1);
        ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> terminationLatch.countDown());
        runner.run();
        this.waitUntilNotificationsArrived(3);
        DefaultComponentLocation flowWithAsyncLocation = FLOW_WITH_ASYNC.appendProcessorsPart();
        DefaultComponentLocation asyncLocation = flowWithAsyncLocation.appendLocationPart("0", ASYNC, CONFIG_FILE_NAME, OptionalInt.of(105), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(asyncLocation);
        DefaultComponentLocation asyncProcessorsLocation = asyncLocation.appendProcessorsPart();
        this.assertNextProcessorLocationIs(asyncProcessorsLocation.appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(106), OptionalInt.of(13)));
        this.assertNextProcessorLocationIs(asyncProcessorsLocation.appendLocationPart("1", VALIDATION_IS_TRUE, CONFIG_FILE_NAME, OptionalInt.of(107), OptionalInt.of(13)));
        this.assertNoNextProcessorNotification();
        terminationLatch.await();
    }

    @Test
    public void defaultErrorHandlerFromFlowCannotBeAccesed() throws Exception {
        Location defaultErrorHandlerLoggerLocation = Location.builder().globalName("flowWithSingleMp").addErrorHandlerPart().addIndexPart(0).addProcessorsPart().addIndexPart(0).build();
        Optional component = this.configurationComponentLocator.find(defaultErrorHandlerLoggerLocation);
        Assert.assertThat((Object)component.isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void defaultErrorHandler() throws Exception {
        Location defaultErrorHandlerLoggerLocation = Location.builder().globalName("defaultErrorHandler").build();
        Optional component = this.configurationComponentLocator.find(defaultErrorHandlerLoggerLocation);
        Assert.assertThat((Object)component.isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void aggregatorWithOneRoute() throws Exception {
        this.flowRunner("aggregatorWithOneRoute").run();
        this.waitUntilNotificationsArrived(2);
        DefaultComponentLocation flowWithSingleRouteAggregator = FLOW_WITH_AGGREGATOR_ONE_ROUTE.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        DefaultComponentLocation aggregatorLocation = flowWithSingleRouteAggregator.appendLocationPart("0", AGGREGATOR, CONFIG_FILE_NAME, OptionalInt.of(118), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(aggregatorLocation);
        DefaultComponentLocation aggregatorRoute0 = aggregatorLocation.appendRoutePart().appendLocationPart("0", AGGREGATION_COMPLETE, CONFIG_FILE_NAME, OptionalInt.of(119), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(120), OptionalInt.of(17));
        this.assertNextProcessorLocationIs(aggregatorRoute0);
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void aggregatorWithTwoRoutes() throws Exception {
        String flowName = "aggregatorWithTwoRoutes";
        this.flowRunner("aggregatorWithTwoRoutes").run();
        this.waitUntilNotificationsArrived(2);
        DefaultComponentLocation flowWithSingleRouteAggregator = FLOW_WITH_AGGREGATOR_TWO_ROUTES.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        DefaultComponentLocation aggregatorLocation = flowWithSingleRouteAggregator.appendLocationPart("0", AGGREGATOR, CONFIG_FILE_NAME, OptionalInt.of(126), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(aggregatorLocation);
        DefaultComponentLocation aggregatorRoute0 = aggregatorLocation.appendRoutePart().appendLocationPart("0", AGGREGATION_INCREMENTAL, CONFIG_FILE_NAME, OptionalInt.of(127), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(128), OptionalInt.of(17));
        this.assertNextProcessorLocationIs(aggregatorRoute0);
        this.flowRunner("aggregatorWithTwoRoutes").run();
        this.waitUntilNotificationsArrived(2);
        this.assertNextProcessorLocationIs(aggregatorLocation);
        DefaultComponentLocation aggregatorRoute1 = aggregatorLocation.appendRoutePart().appendLocationPart("1", AGGREGATION_COMPLETE, CONFIG_FILE_NAME, OptionalInt.of(130), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(131), OptionalInt.of(17));
        this.assertNextProcessorLocationIs(aggregatorRoute1);
        this.assertNoNextProcessorNotification();
    }

    @Test
    public void aggregatorWithTwoRoutesAndContent() throws Exception {
        String flowName = "aggregatorWithTwoRoutesAndContent";
        this.flowRunner("aggregatorWithTwoRoutesAndContent").run();
        this.waitUntilNotificationsArrived(2);
        DefaultComponentLocation flowWithSingleRouteAggregator = FLOW_WITH_AGGREGATOR_TWO_ROUTES_AND_CONTENT.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        DefaultComponentLocation aggregatorLocation = flowWithSingleRouteAggregator.appendLocationPart("0", AGGREGATOR, CONFIG_FILE_NAME, OptionalInt.of(137), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(aggregatorLocation);
        DefaultComponentLocation aggregatorRoute0 = aggregatorLocation.appendRoutePart().appendLocationPart("0", AGGREGATION_INCREMENTAL, CONFIG_FILE_NAME, OptionalInt.of(139), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(140), OptionalInt.of(17));
        this.assertNextProcessorLocationIs(aggregatorRoute0);
        this.flowRunner("aggregatorWithTwoRoutesAndContent").run();
        this.waitUntilNotificationsArrived(2);
        this.assertNextProcessorLocationIs(aggregatorLocation);
        DefaultComponentLocation aggregatorRoute1 = aggregatorLocation.appendRoutePart().appendLocationPart("1", AGGREGATION_COMPLETE, CONFIG_FILE_NAME, OptionalInt.of(142), OptionalInt.of(13)).appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(143), OptionalInt.of(17));
        this.assertNextProcessorLocationIs(aggregatorRoute1);
        this.assertNoNextProcessorNotification();
    }

    @Test
    @Issue(value="MULE-18504")
    public void operationWithChain() throws Exception {
        String flowName = "operationWithChain";
        this.flowRunner("operationWithChain").run();
        this.waitUntilNotificationsArrived(2);
        DefaultComponentLocation operationWithChain = FLOW_WITH_OPERATION_WITH_CHAIN.appendLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        DefaultComponentLocation operationWithChainLocation = operationWithChain.appendLocationPart("0", TAP_PHONES, CONFIG_FILE_NAME, OptionalInt.of(149), OptionalInt.of(9));
        this.assertNextProcessorLocationIs(operationWithChainLocation);
        DefaultComponentLocation innerChainRoute = operationWithChainLocation.appendProcessorsPart().appendLocationPart("0", LOGGER, CONFIG_FILE_NAME, OptionalInt.of(150), OptionalInt.of(13));
        this.assertNextProcessorLocationIs(innerChainRoute);
        this.assertNoNextProcessorNotification();
    }

    private void waitUntilNotificationsArrived(final int minimumRequiredNotifications) {
        new PollingProber(5000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return ComponentLocationTestCase.this.getNotificationsStore().getNotifications().size() >= minimumRequiredNotifications;
            }

            public String describeFailure() {
                return "not all expected notifications arrived";
            }
        });
    }

    private void assertNoNextProcessorNotification() {
        ProcessorNotificationStore processorNotificationStore = this.getNotificationsStore();
        Iterator iterator = processorNotificationStore.getNotifications().iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Is.is((Object)false));
    }

    private void assertNextProcessorLocationIs(DefaultComponentLocation componentLocation) {
        ProcessorNotificationStore processorNotificationStore = this.getNotificationsStore();
        Assert.assertThat((Object)processorNotificationStore.getNotifications().isEmpty(), (Matcher)Is.is((Object)false));
        MessageProcessorNotification processorNotification = (MessageProcessorNotification)processorNotificationStore.getNotifications().get(0);
        Assert.assertThat((Object)processorNotification.getComponent().getLocation().getLocation(), (Matcher)Is.is((Object)componentLocation.getLocation()));
        Assert.assertThat((Object)processorNotification.getComponent().getLocation(), (Matcher)Is.is((Object)componentLocation));
        processorNotificationStore.getNotifications().remove(0);
    }

    private void assertNextProcessorLocationsAre(List<DefaultComponentLocation> componentLocations) {
        StringBuilder errors = new StringBuilder();
        for (DefaultComponentLocation loc : componentLocations) {
            String errorString;
            for (DefaultComponentLocation componentLocation : componentLocations) {
                try {
                    this.assertNextProcessorLocationIs(componentLocation);
                    errors = new StringBuilder();
                    break;
                }
                catch (AssertionError e) {
                    errors.append(((Throwable)((Object)e)).getMessage());
                }
            }
            if ((errorString = errors.toString()).isEmpty()) continue;
            Assert.fail((String)String.format("Not every componentLocation was found in the notification list. %s", errorString));
        }
    }

    private ProcessorNotificationStore getNotificationsStore() {
        return (ProcessorNotificationStore)((Object)this.registry.lookupByName("notificationsStore").get());
    }
}

