/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.matcher.HasClassInHierarchy;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.routing.ThreadCaptor;

@Feature(value="Routers")
@Story(value="Scatter Gather")
public class ScatterGatherRouterTestCase
extends AbstractIntegrationTestCase {
    private static final String EXCEPTION_MESSAGE_TITLE_PREFIX = "Error(s) were found for route(s):" + System.lineSeparator();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty timeout = new SystemProperty("scatterGather.timeout", "5000");

    protected String getConfigFile() {
        return "routers/scatter-gather-test.xml";
    }

    @Test
    @Description(value="Minimal configuration with default collect-map strategy.")
    public void minimalConfiguration() throws Exception {
        ((FlowRunner)this.flowRunner("minimalConfig").withPayload((Object)"foo")).run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-map strategy and target configured.")
    public void minimalConfigurationTarget() throws Exception {
        this.flowRunner("minimalConfigTarget").run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-map strategy and target configured with targetType Message.")
    public void minimalConfigurationTargetMessage() throws Exception {
        this.flowRunner("minimalConfigTargetMessage").run();
    }

    @Test
    @Description(value="Minimal configuration with default with collect-list strategy configured.")
    public void minimalConfigurationCollectList() throws Exception {
        this.flowRunner("minimalConfigCollectList").run();
    }

    @Test
    @Description(value="Router request fails with runtime exception is payload is consumable.")
    public void consumablePayload() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(MuleRuntimeException.class));
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Cannot copy message with a stream payload")));
        ((FlowRunner)this.flowRunner("minimalConfig").withPayload((Object)new ByteArrayInputStream("hello world".getBytes()))).run();
    }

    @Test
    @Description(value="Router times out if routes take longer than the timeout configured to complete.")
    public void timeout() throws Exception {
        this.expectedException.expectCause(HasClassInHierarchy.withClassName((String)"org.mule.runtime.core.privileged.routing.CompositeRoutingException"));
        this.flowRunner("timeout").run();
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithException() throws Exception {
        this.assertRouteException("routeWithException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: org.mule.runtime.api.exception.DefaultMuleException: An error occurred.", DefaultMuleException.class);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExceptionWithMessage() throws Exception {
        this.assertRouteException("routeWithExceptionWithMessage", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: org.mule.runtime.api.exception.DefaultMuleException: I'm a message", DefaultMuleException.class);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithNonMuleException() throws Exception {
        this.assertRouteException("routeWithNonMuleException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: java.lang.NullPointerException: nonMule", NullPointerException.class);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExpressionException() throws Exception {
        this.assertRouteException("routeWithExpressionException", (String message) -> MatcherAssert.assertThat((Object)message, (Matcher)Matchers.both((Matcher)Matchers.containsString((String)EXCEPTION_MESSAGE_TITLE_PREFIX)).and(Matchers.containsString((String)"1: org.mule.runtime.core.api.expression.ExpressionRuntimeException: \"Script 'invalidExpr' has errors:"))), ExpressionRuntimeException.class);
    }

    @Test
    @Description(value="An error in a route when executing sequentially results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExceptionInSequentialProcessing() throws Exception {
        this.assertRouteException("routeWithExceptionInSequentialProcessing", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: org.mule.runtime.api.exception.DefaultMuleException: An error occurred.", DefaultMuleException.class);
    }

    private void assertRouteException(String flow, String exceptionMessageStart, Class exceptionType) throws Exception {
        this.assertRouteException(flow, (String message) -> MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.startsWith((String)exceptionMessageStart)), exceptionType);
    }

    private void assertRouteException(String flow, Consumer<String> exceptionMessageMatcher, Class exceptionType) throws Exception {
        try {
            this.flowRunner(flow).run();
            Assert.fail((String)"Was expecting a failure");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)HasClassInHierarchy.withClassName((String)"org.mule.runtime.core.privileged.routing.CompositeRoutingException"));
            Throwable compositeRoutingException = e.getCause();
            exceptionMessageMatcher.accept(compositeRoutingException.getMessage());
            List exceptions = ((ComposedErrorException)compositeRoutingException).getErrors();
            MatcherAssert.assertThat((Object)exceptions, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((Error)exceptions.get(0)).getCause(), (Matcher)CoreMatchers.instanceOf((Class)exceptionType));
        }
    }

    @Test
    @Story(value="Max concurrency")
    @Description(value="Only a single thread is used to process all routes when configured with maxConcurrency=1.")
    public void sequentialProcessing() throws Exception {
        ((FlowRunner)this.flowRunner("sequentialProcessing").withVariable("latch", (Object)new Latch())).run();
        MatcherAssert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    @Description(value="Only a single thread is used to process all routes when a transaction is active.")
    public void withinTransaction() throws Exception {
        ((FlowRunner)this.flowRunner("withinTransaction").withVariable("latch", (Object)new Latch())).run();
        MatcherAssert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    @Description(value="The result of all route failures and results are available via errorMessage in error-handler..")
    public void errorHandler() throws Exception {
        this.flowRunner("errorHandler").run();
    }

    @Test
    @Description(value="Variables set before route are conserved after router. Variables set in routes are merged and available after router.")
    public void variables() throws Exception {
        this.flowRunner("variables").run();
    }

    @Test
    @Description(value="Validates that scatter-gather can be used correctly within an error handler")
    public void scatterGatherInsideErrorHandler() throws Exception {
        CoreEvent event = this.flowRunner("scatterGatherInsideErrorHandler").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"hello"));
    }

    @Test
    @Description(value="Validates that if a route of a scatter-gather within an error handler fails, then only that route will have an error")
    public void scatterGatherInsideErrorHandlerThrowsError() throws Exception {
        CoreEvent event = this.flowRunner("scatterGatherInsideErrorHandlerThrowsError").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"hello"));
    }

    @Test
    @Issue(value="MULE-18154")
    @Description(value="Validates that an error handler in a scatter-gather route can be used correctly")
    public void errorHandlerInsideScatterGather() throws Exception {
        this.flowRunner("errorHandlerInsideScatterGather").run();
    }

    @Description(value="By default routes are run concurrently and multiple threads are used.")
    public void concurrent() throws Exception {
        ((FlowRunner)this.flowRunner("concurrent").withVariable("latch", (Object)new Latch())).run();
        MatcherAssert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    @Description(value="The resulting Map<String, Message> result maintains the correct data-type for each Message.")
    public void returnsCorrectDataType() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("dataType").withMediaType(MediaType.JSON)).run().getMessage();
        MatcherAssert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Map messageList = (Map)response.getPayload().getValue();
        MatcherAssert.assertThat((Object)messageList.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Message)messageList.get("0")).getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
        MatcherAssert.assertThat((Object)((Message)messageList.get("1")).getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
        MatcherAssert.assertThat((Object)((Message)messageList.get("2")).getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
    }

    @Test
    @Description(value="The resulting Map<String, Message> is iterable in the same order as the defined routes.")
    @Issue(value="MULE-18040")
    public void resultsInOrder() throws Exception {
        Message response = this.flowRunner("resultsInOrder").run().getMessage();
        MatcherAssert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Map messageList = (Map)response.getPayload().getValue();
        MatcherAssert.assertThat((Object)messageList.size(), (Matcher)CoreMatchers.is((Object)12));
        MatcherAssert.assertThat(messageList.values().stream().map(m -> m.getPayload().getValue()).collect(Collectors.toList()), (Matcher)CoreMatchers.is(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L")));
    }

    @Test
    @Issue(value="MULE-18227")
    @Description(value="Check that parallel execution routes do not cause race conditions when handling SdkInternalContext")
    public void foreachWithinScatterGatherWithSdkOperation() throws Exception {
        this.flowRunner("foreachWithinScatterGatherWithSdkOperation").run();
    }

    @Test
    @Issue(value="W-10619784")
    @Description(value="With On Error continue, even when forEach has failed with an error within any route, each route should be processed accordingly.")
    public void foreachErrorInScatterGather() throws Exception {
        CoreEvent event = this.flowRunner("ForeachErrorInScatterGather").run();
        MatcherAssert.assertThat((Object)((TypedValue)event.getVariables().get("variable0")).getValue(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((TypedValue)event.getVariables().get("variable1")).getValue(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    public static final class ThrowNpeProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new NullPointerException("nonMule");
        }
    }
}

