/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.tck.util.FlowTraceUtils;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Logging")
@Story(value="Flow Stack")
public class FlowStackTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/flow-stack-config.xml";
    }

    @Before
    public void before() {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        FlowTraceUtils.FlowStackAsserter.stackToAssert = null;
        FlowTraceUtils.FlowStackAsyncAsserter.latch = new CountDownLatch(1);
    }

    @Test
    public void flowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("flowStatic").withPayload((Object)"Test Message")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStatic", (String)"flowStatic/processors/0")});
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.withChainIdentifier((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)"flow")), FlowTraceUtils.withChainIdentifier((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)"flow"))});
    }

    @Test
    public void subFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStatic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStatic", (String)"subFlowStatic/processors/0")});
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.withChainIdentifier((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)"subflow")), FlowTraceUtils.withChainIdentifier((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)"flow"))});
    }

    @Test
    public void flowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamic", (String)"flowDynamic/processors/0")});
    }

    @Test
    public void subFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamic", (String)"subFlowDynamic/processors/0")});
    }

    @Test
    public void secondFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("secondFlowStatic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondFlowStatic", (String)"secondFlowStatic/processors/1")});
    }

    @Test
    public void secondSubFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("secondSubFlowStatic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondSubFlowStatic", (String)"secondSubFlowStatic/processors/1")});
    }

    @Test
    public void secondFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("secondFlowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondFlowDynamic", (String)"secondFlowDynamic/processors/1")});
    }

    @Test
    public void secondSubFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("secondSubFlowDynamic").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"secondSubFlowDynamic", (String)"secondSubFlowDynamic/processors/1")});
    }

    @Test
    public void flowStaticWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flowInAsync", (String)"flowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithAsync", (String)"flowStaticWithAsync/processors/0/processors/0")});
    }

    @Test
    public void subFlowStaticWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlowInAsync", (String)"subFlowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithAsync", (String)"subFlowStaticWithAsync/processors/0/processors/0")});
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.withChainIdentifier((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)"subflow")), FlowTraceUtils.withChainIdentifier((ComponentIdentifier)ComponentIdentifier.buildFromStringRepresentation((String)"flow"))});
    }

    @Test
    public void flowDynamicWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flowInAsync", (String)"flowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithAsync", (String)"flowDynamicWithAsync/processors/0/processors/0")});
    }

    @Test
    public void subFlowDynamicWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithAsync").withPayload((Object)"payload")).run();
        FlowTraceUtils.FlowStackAsyncAsserter.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlowInAsync", (String)"subFlowInAsync/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithAsync", (String)"subFlowDynamicWithAsync/processors/0/processors/0")});
    }

    @Test
    public void flowStaticWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithChoice", (String)"flowStaticWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void subFlowStaticWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithChoice", (String)"subFlowStaticWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void flowDynamicWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithChoice", (String)"flowDynamicWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void subFlowDynamicWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithChoice").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithChoice", (String)"subFlowDynamicWithChoice/processors/0/route/0/processors/0")});
    }

    @Test
    public void flowStaticWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithScatterGather", (String)"flowStaticWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowStaticWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithScatterGather", (String)"subFlowStaticWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowDynamicWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithScatterGather", (String)"flowDynamicWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowDynamicWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithScatterGather").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithScatterGather", (String)"subFlowDynamicWithScatterGather/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowStaticWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowStaticWithScatterGatherChain", (String)"flowStaticWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowStaticWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowStaticWithScatterGatherChain", (String)"subFlowStaticWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowDynamicWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowDynamicWithScatterGatherChain", (String)"flowDynamicWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void subFlowDynamicWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithScatterGatherChain").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"subFlow", (String)"subFlow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"subFlowDynamicWithScatterGatherChain", (String)"subFlowDynamicWithScatterGatherChain/processors/0/route/1/processors/0")});
    }

    @Test
    public void flowForEach() throws Exception {
        ((FlowRunner)this.flowRunner("flowForEach").withPayload((Object)"payload")).run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowForEach", (String)"flowForEach/processors/0/processors/1")});
    }

    @Test
    public void flowParallelForeach() throws Exception {
        this.flowRunner("flowParallelForeach").run();
        Assert.assertThat((Object)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        FlowTraceUtils.assertStackElements((FlowCallStack)FlowTraceUtils.FlowStackAsserter.stackToAssert, (Matcher[])new Matcher[]{FlowTraceUtils.isFlowStackElement((String)"flow", (String)"flow/processors/0"), FlowTraceUtils.isFlowStackElement((String)"flowParallelForeach", (String)"flowParallelForeach/processors/0/processors/1")});
    }
}

