/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.el;

import io.qameta.allure.Feature;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Expression Language")
public class ExpressionLanguageConcurrencyTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/el/expression-language-concurrency-config.xml";
    }

    @Test
    public void testConcurrentEvaluation() throws Exception {
        int N = 100;
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(100);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(() -> {
                try {
                    start.await();
                    ((FlowRunner)this.flowRunner("slowRequestHandler").withPayload((Object)"foo")).run();
                }
                catch (Exception e) {
                    errors.incrementAndGet();
                }
                finally {
                    end.countDown();
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    public static long sleep(long millis) {
        try {
            Thread.sleep(millis);
            return millis;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

