/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.processors;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Core Components")
@Story(value="Parse Template")
public class ParseTemplateTestCase
extends AbstractIntegrationTestCase {
    private static final String PARSED_NO_EXPRESSION = "This template does not have any expressions to parse";
    private static final String PARSED_DW_EXPRESSION = "This template has a DW expression to parse from dw-expression flow. Remember, the name of the flow is dw-expression";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public String getConfigFile() {
        return "org/mule/processors/parse-template-config.xml";
    }

    @Test
    public void noExpressionInline() throws Exception {
        CoreEvent event = this.flowRunner("no-expression-inline").run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    public void dwExpressionInline() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("dw-expression-inline").withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
    }

    @Test
    public void noExpressionFromFile() throws Exception {
        CoreEvent event = this.flowRunner("no-expression").run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    public void dwExpressionFromFile() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("dw-expression").withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
    }

    @Test
    public void noExpressionFromLocation() throws Exception {
        CoreEvent event = this.flowRunner("no-expression-from-location").run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    public void dwExpressionFromLocation() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("dw-expression-from-location").withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
    }

    @Test
    public void withTargetDefaultTargetValueDefinedInline() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-target").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)((TypedValue)event.getVariables().get("targetVar")).getValue();
        String previousdPayload = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
        Assert.assertEquals((Object)previousdPayload, (Object)startingPayload);
    }

    @Test
    public void withTargetValueButNoTargetShouldRaiseException() throws Exception {
        this.expectedException.expectCause(Matchers.isA(IllegalArgumentException.class));
        ((FlowRunner)this.flowRunner("with-target-value-no-target").withVariable("flowName", (Object)"dw-expression")).run();
    }

    @Test
    public void withCustomTargetValue() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-custom-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        String savedPayload = (String)((TypedValue)event.getVariables().get("targetVar")).getValue();
        String previousPayload = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)savedPayload);
        Assert.assertEquals((Object)startingPayload, (Object)previousPayload);
    }

    @Test
    public void withMessageBindingExpression() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-message-binding-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        Message savedTypedValue = (Message)((TypedValue)event.getVariables().get("targetVar")).getValue();
        String previousPayload = (String)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)savedTypedValue.getPayload().getValue(), (Matcher)Matchers.is((Object)PARSED_DW_EXPRESSION));
        MatcherAssert.assertThat((Object)startingPayload, (Matcher)Matchers.is((Object)previousPayload));
    }

    @Test
    public void payloadFromMessageBindingExpression() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-payload-from-message-binding-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        String savedTypedValue = (String)((TypedValue)event.getVariables().get("targetVar")).getValue();
        String previousPayload = (String)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)savedTypedValue, (Matcher)Matchers.is((Object)PARSED_DW_EXPRESSION));
        MatcherAssert.assertThat((Object)startingPayload, (Matcher)Matchers.is((Object)previousPayload));
    }

    @Test
    public void nestedExpressions() throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("nestedExpressionsFlow").withVariable("individuals", (Object)"alpinos")).withVariable("quantity", (Object)"3")).withVariable("origin", (Object)"war")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"They were 3 alpinos that came from war"));
    }

    @Test
    public void expressionEscaped() throws Exception {
        CoreEvent event = this.flowRunner("expressionEscaped").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"His name is #[pepito]"));
    }

    @Test
    public void nestedExpressionsWithNonexistingValues() throws Exception {
        this.expectedException.expectMessage("Unable to resolve reference of: `pepito`.");
        this.flowRunner("nestedExpressionsFlowWithNonexistentValues").run();
    }

    @Test
    public void nestedExpressionsAndQuote() throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("nestedExpressionsAndQuoteFlow").withVariable("individuals", (Object)"alpinos")).withVariable("quantity", (Object)"3")).withVariable("origin", (Object)"war")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"They weren't 3 alpinos that came from war"));
    }

    @Test
    public void nestedQuotedExpressionsAndQuoteFlow() throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("nestedQuotedExpressionsAndQuoteFlow").withVariable("individuals", (Object)"alpinos")).withVariable("quantity", (Object)"3")).withVariable("origin", (Object)"war")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"They weren't 3 alpinos that came from war"));
    }

    @Test
    public void nestedExpressionsFromFile() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("nestedExpressionsFlowFromFile").withVariable("chorusPhrase", (Object)"tiaitai rataplam")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"tiaitai rataplam, que venian de la guerra"));
    }

    @Test
    public void mimeTypeIsGuessed() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("jsonTemplateFromFile").withVariable("name", (Object)"El mismisimo Luciano Raineri Marchina")).run();
        MatcherAssert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasMediaType((MediaType)MediaType.JSON));
    }

    @Test
    public void overriddenDataType() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("overriddenDataType").withVariable("flowName", (Object)"what do you care?")).run();
        MatcherAssert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasMediaType((MediaType)MediaType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_16)));
    }

    @Test
    public void overriddenEncodingFromMediaTypeParsing() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("overriddenEncodingFromMediaType").withVariable("flowName", (Object)"what do you care?")).run();
        MatcherAssert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasMediaType((MediaType)MediaType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_16)));
    }

    @Test
    public void encodingFromMediaTypeParsingIsReplacedIfSpecifiedInAttribute() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("encodingFromMediaTypeAndAttribute").withVariable("flowName", (Object)"what do you care?")).run();
        MatcherAssert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasMediaType((MediaType)MediaType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_16)));
    }

    @Test
    public void loadTemplateWithCustomEncoding() throws Exception {
        CoreEvent customEncodingEvent = this.flowRunner("loadWithCustomEncoding").run();
        CoreEvent defaultEncodingEvent = this.flowRunner("loadWithDefaultEncoding").run();
        MatcherAssert.assertThat((Object)customEncodingEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)defaultEncodingEvent.getMessage().getPayload()))));
    }

    @Test
    public void targetVariableAndValue() throws Exception {
        CoreEvent event = this.flowRunner("targetVariableAndValue").run();
        String msg = (String)((TypedValue)event.getVariables().get("someVar")).getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    @Issue(value="MULE-19900")
    public void nestedBackslash() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("nestedBackslash").withVariable("method", (Object)"GET")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"get:\\test\\GET"));
    }

    @Test
    public void subexpressionsExampleFromDocs() throws Exception {
        CoreEvent event = this.flowRunner("subexpressionsExampleFromDocs").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)("<td>hello WORLD</td>" + System.lineSeparator() + "<td>hello WORLD</td>" + System.lineSeparator() + "<td>hello upper(\"world\")</td>" + System.lineSeparator() + "<td>hello ++ upper(\"world\")</td>")));
    }

    @Test
    public void escapeExampleFromDocs() throws Exception {
        CoreEvent event = this.flowRunner("escapeExampleFromDocs").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)("<td>#[</td>" + System.lineSeparator() + "<td>abcd#[-1234WORLD.log</td>" + System.lineSeparator() + "<td>'abc'def'</td>" + System.lineSeparator() + "<td>abc'def</td>" + System.lineSeparator() + "<td>\"xyz\"xyz\"</td>" + System.lineSeparator() + "<td>xyz\"xyz</td>" + System.lineSeparator() + "<td>abc$DEF#ghi\\[JKL]</td>")));
    }

    @Test
    @Issue(value="W-15141905")
    public void nestedExpression() throws Exception {
        String payload = "#[sum([1, 2, 3])]";
        CoreEvent event = ((FlowRunner)this.flowRunner("nestedExpression").withPayload((Object)payload)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"#[sum([1, 2, 3])]"));
    }

    @Test
    @Ignore(value="This case is not really supported at the moment. This test is just a remainder of that.")
    public void expressionWithinTransformation() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("expressionWithinTransformation").withPayload((Object)"world")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"uppercase payload is: WORLD"));
    }
}

