/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
@RunnerDelegateTo(value=Parameterized.class)
public class GracefulShutdownTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty propagateDisposeError = new SystemProperty("mule.lifecycle.failOnFirstDisposeError", "");
    private final String configFile;

    @Parameterized.Parameters(name="{0}")
    public static List<String> parameters() {
        return Arrays.asList("org/mule/shutdown/flow-with-operation.xml", "org/mule/shutdown/flow-with-failing-operation.xml", "org/mule/shutdown/flow-with-flow-ref.xml", "org/mule/shutdown/flow-with-operation-in-error-handler.xml", "org/mule/shutdown/flow-with-tx-flow-ref.xml", "org/mule/shutdown/flow-with-tx-scope.xml", "org/mule/shutdown/flow-with-scatter-gather-and-flow-ref.xml");
    }

    public GracefulShutdownTestCase(String configFile) {
        this.configFile = configFile;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    @Description(value="Verify that the graceful shutdown occurs in a timely manner")
    public void flowStopTimelyManner() {
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 4; ++i) {
            try {
                this.flowRunner("flow").run();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isGracefulShutdown() {
        return true;
    }
}

