/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.rules.HttpServerRule;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.matcher.HasClassInHierarchy;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.routing.ThreadCaptor;

@Feature(value="Routers")
@Story(value="Parallel For Each")
public class ParallelForEachTestCase
extends AbstractIntegrationTestCase {
    private static final ComponentIdentifier EXPECTED = ComponentIdentifier.builder().namespace("APP").name("EXPECTED").build();
    private static final String EXCEPTION_MESSAGE_TITLE_PREFIX = "Error(s) were found for route(s):" + System.lineSeparator();
    private final String[] fruitList = new String[]{"apple", "banana", "orange"};
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public HttpServerRule httpServerRules = new HttpServerRule("port");
    @Rule
    public SystemProperty parallelForeachFlattenMessage = new SystemProperty("mule.parallelForeach.flattenMessage", "true");

    protected String getConfigFile() {
        return "routers/parallel-foreach-config.xml";
    }

    @Test
    @Description(value="Minimal configuration with default collect-list strategy.")
    public void minimalConfiguration() throws Exception {
        ((FlowRunner)this.flowRunner("minimalConfig").withPayload((Object)this.fruitList)).run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-list strategy with nested list.")
    public void minimalConfigurationNested() throws Exception {
        ((FlowRunner)this.flowRunner("minimalConfigNested").withPayload(Arrays.asList({"1", "2", "3", "4"}, {"a", "b", "c", "d"}, {"i", "ii", "iii", "iv"}))).run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-list strategy and custom collection expression")
    public void minimalConfigurationCollectionExpression() throws Exception {
        this.flowRunner("minimalConfigurationCollectionExpression").run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-list strategy and target configured.")
    public void minimalConfigurationTarget() throws Exception {
        ((FlowRunner)this.flowRunner("minimalConfigTarget").withPayload((Object)this.fruitList)).run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-list strategy and target configured with targetType Message.")
    public void minimalConfigurationTargetMessage() throws Exception {
        ((FlowRunner)this.flowRunner("minimalConfigTargetMessage").withPayload((Object)this.fruitList)).run();
    }

    @Test
    @Description(value="Router times out if routes take longer than the timeout configured to complete.")
    public void timeout() throws Exception {
        this.expectedException.expectCause(HasClassInHierarchy.withClassName((String)"org.mule.runtime.core.internal.routing.result.CompositeRoutingException"));
        ((FlowRunner)this.flowRunner("timeout").withPayload((Object)this.fruitList)).run();
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithException() {
        this.assertRouteException("routeWithException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: org.mule.runtime.api.exception.DefaultMuleException: An error occurred.", DefaultMuleException.class, EXPECTED);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExceptionWithMessage() {
        this.assertRouteException("routeWithExceptionWithMessage", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: org.mule.runtime.api.exception.DefaultMuleException: I'm a message", DefaultMuleException.class, EXPECTED);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithNonMuleException() {
        this.assertRouteException("routeWithNonMuleException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: java.lang.NullPointerException: nonMule", NullPointerException.class, Errors.ComponentIdentifiers.Handleable.UNKNOWN);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExpressionException() {
        this.assertRouteException("routeWithExpressionException", (String message) -> MatcherAssert.assertThat((Object)message, (Matcher)Matchers.both((Matcher)Matchers.containsString((String)EXCEPTION_MESSAGE_TITLE_PREFIX)).and(Matchers.containsString((String)"1: org.mule.runtime.core.api.expression.ExpressionRuntimeException: \"Script 'invalidExpr' has errors:"))), ExpressionRuntimeException.class, Errors.ComponentIdentifiers.Handleable.EXPRESSION);
    }

    @Test
    @Description(value="An error in a route when executing sequentially results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExceptionInSequentialProcessing() {
        this.assertRouteException("routeWithExceptionInSequentialProcessing", EXCEPTION_MESSAGE_TITLE_PREFIX + "\tRoute 1: org.mule.runtime.api.exception.DefaultMuleException: An error occurred.", DefaultMuleException.class, EXPECTED);
    }

    private void assertRouteException(String flow, String exceptionMessageStart, Class exceptionType, ComponentIdentifier errorType) {
        this.assertRouteException(flow, (String message) -> MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.startsWith((String)exceptionMessageStart)), exceptionType, errorType);
    }

    private void assertRouteException(String flow, Consumer<String> exceptionMessageMatcher, Class exceptionType, ComponentIdentifier errorType) {
        try {
            ((FlowRunner)this.flowRunner(flow).withPayload((Object)this.fruitList)).run();
            Assert.fail((String)"Was expecting a failure");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)HasClassInHierarchy.withClassName((String)"org.mule.runtime.core.internal.routing.result.CompositeRoutingException"));
            Throwable compositeRoutingException = e.getCause();
            exceptionMessageMatcher.accept(compositeRoutingException.getMessage());
            List exceptions = ((ComposedErrorException)compositeRoutingException).getErrors();
            MatcherAssert.assertThat((Object)exceptions, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((Error)exceptions.get(0)).getErrorType(), (Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)errorType));
            MatcherAssert.assertThat((Object)((Error)exceptions.get(0)).getCause(), (Matcher)CoreMatchers.instanceOf((Class)exceptionType));
        }
    }

    @Test
    @Story(value="Max concurrency")
    @Description(value="Only a single thread is used to process all routes when configured with maxConcurrency=1.")
    public void sequentialProcessing() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("sequentialProcessing").withPayload((Object)this.fruitList)).withVariable("latch", (Object)new Latch())).run();
        MatcherAssert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    @Description(value="The result of all route failures and results are available via errorMessage in error-handler..")
    public void errorHandler() throws Exception {
        ((FlowRunner)this.flowRunner("errorHandler").withPayload((Object)this.fruitList)).run();
    }

    @Test
    @Description(value="Variables set before route are conserved after router. Variables set in routes are merged and available after router.")
    public void variables() throws Exception {
        ((FlowRunner)this.flowRunner("variables").withPayload((Object)this.fruitList)).run();
    }

    @Test
    @Description(value="Validates that parallel foreach can be used correctly within an error handler")
    public void parallelForEachInErrorHandler() throws Exception {
        CoreEvent event = this.flowRunner("parallelForEachInErrorHandler").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"hello"));
    }

    @Test
    @Description(value="Validates that parallel foreach can be used correctly within a nested error handler")
    public void parallelForEachInNestedErrorHandler() throws Exception {
        CoreEvent event = this.flowRunner("parallelForEachInNestedErrorHandler").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"hello"));
    }

    @Test
    @Description(value="By default routes are run concurrently and multiple threads are used.")
    public void concurrent() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("concurrent").withPayload((Object)this.fruitList)).withVariable("latch", (Object)new Latch())).run();
        MatcherAssert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    @Issue(value="MULE-18227")
    @Description(value="Check that parallel execution routes do not cause race conditions when handling SdkInternalContext")
    public void parallelForEachWithSdkOperation() throws Exception {
        this.flowRunner("parallelForEachWithSdkOperation").run();
    }

    @Test
    @Issue(value="MULE-20067")
    public void pagedResults() throws Exception {
        this.flowRunner("pagedResults").run();
    }

    public static final class ThrowNpeProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new NullPointerException("nonMule");
        }
    }
}

