/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.properties;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
@RunnerDelegateTo(value=Parameterized.class)
public class CustomPropertiesResolverExtensionTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private ConfigurationProperties configurationProperties;
    private final String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> configs() {
        return Arrays.asList("properties/custom-properties-resolver-extension-config.xml", "properties/custom-properties-resolver-extension-deprecated-config.xml");
    }

    public CustomPropertiesResolverExtensionTestCase(String configFile) {
        this.configFile = configFile;
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        Assert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("lifecycle::initialize").get()), (Matcher)Is.is((Object)"1"));
        Assert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("lifecycle::dispose").get()), (Matcher)Is.is((Object)"1"));
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void propertiesAreResolvedCorrectly() {
        Assert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("key1").get()), (Matcher)Is.is((Object)"test.key1:value1:AES:CBC"));
        Assert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("key2").get()), (Matcher)Is.is((Object)"test.key2:value2:AES:CBC"));
    }

    @Test
    public void providerIsInitialisedCorrectly() {
        Assert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("lifecycle::initialize").get()), (Matcher)Is.is((Object)"1"));
        Assert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("lifecycle::dispose").get()), (Matcher)Is.is((Object)"0"));
    }
}

