/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.interception.FlowInterceptor;
import org.mule.runtime.api.interception.FlowInterceptorFactory;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Interception API")
@Story(value="Flow Interception Story")
@RunnerDelegateTo(value=Parameterized.class)
public class FlowInterceptorFactoryMutationTestCase
extends AbstractIntegrationTestCase {
    private final boolean mutateEventBefore;
    private final boolean mutateEventAfter;

    public FlowInterceptorFactoryMutationTestCase(boolean mutateEventBefore, boolean mutateEventAfter) {
        this.mutateEventBefore = mutateEventBefore;
        this.mutateEventAfter = mutateEventAfter;
    }

    @Parameterized.Parameters(name="mutateEventBefore: {0}, mutateEventAfter: {1}")
    public static Collection<Boolean[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/flow-interceptor-factory-mutation.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_MutateEventInterceptorFactory", new MutateEventInterceptorFactory(this.mutateEventBefore, this.mutateEventAfter));
        return objects;
    }

    @Test
    public void mutated() {
        String targetFlow = !this.mutateEventBefore && !this.mutateEventAfter ? "mutatedNone" : (this.mutateEventBefore && !this.mutateEventAfter ? "mutatedBefore" : (!this.mutateEventBefore && this.mutateEventAfter ? "mutatedAfter" : "mutatedBeforeAfter"));
        this.flowRunner("mutated").withVariable("targetFlow", (Object)targetFlow);
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public class MutateEventInterceptor
    implements FlowInterceptor {
        private final boolean mutateEventBefore;
        private final boolean mutateEventAfter;

        public MutateEventInterceptor(boolean mutateEventBefore, boolean mutateEventAfter) {
            this.mutateEventBefore = mutateEventBefore;
            this.mutateEventAfter = mutateEventAfter;
        }

        public void before(String flowName, InterceptionEvent event) {
            if (this.mutateEventBefore) {
                event.addVariable("mutatedBefore", (Object)Math.random());
            }
        }

        public void after(String flowName, InterceptionEvent event, Optional<Throwable> thrown) {
            if (this.mutateEventAfter) {
                event.addVariable("mutatedAfter", (Object)Math.random());
            }
        }
    }

    public class MutateEventInterceptorFactory
    implements FlowInterceptorFactory {
        private final boolean mutateEventBefore;
        private final boolean mutateEventAfter;

        public MutateEventInterceptorFactory(boolean mutateEventBefore, boolean mutateEventAfter) {
            this.mutateEventBefore = mutateEventBefore;
            this.mutateEventAfter = mutateEventAfter;
        }

        public boolean intercept(String flowName) {
            return !"mutated".equals(flowName);
        }

        public FlowInterceptor get() {
            return new MutateEventInterceptor(this.mutateEventBefore, this.mutateEventAfter);
        }
    }
}

