/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class FlowErrorStatisticsTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty muleEnableStatistics = new SystemProperty("mule.enable.statistics", "true");
    private String configFile;
    private String flowName;
    boolean statisticsEnabledOriginal;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"flow-error-statistics-config.xml", "defaultErrorHandlerFlow"}, {"flow-error-statistics-default-config.xml", "defaultConfigErrorHandlerFlow"}, {"flow-error-statistics-config.xml", "referencedErrorHandlerFlow"}, {"flow-error-statistics-config.xml", "innerErrorHandlerFlow"});
    }

    public FlowErrorStatisticsTestCase(String configFile, String flowName) {
        this.configFile = configFile;
        this.flowName = flowName;
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/" + this.configFile;
    }

    @Test
    public void executionErrors() throws Exception {
        this.flowRunner(this.flowName).runExpectingException();
        FlowConstructStatistics flowConstructStatistics = this.locator.find(Location.builder().globalName(this.flowName).build()).map(f -> (FlowConstruct)f).map(f -> f.getStatistics()).get();
        Assert.assertThat((Object)flowConstructStatistics.getExecutionErrors(), (Matcher)Matchers.is((Object)1L));
    }
}

