/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.processors;

import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.test.AbstractIntegrationTestCase;

@Epic(value="Error Handling")
@Feature(value="Raise Errors")
public class RaiseErrorTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "raise-error-config.xml";
    }

    @Test
    public void raisesNewErrorType() throws Exception {
        this.expectedError.expectMessage(Matchers.is((Object)"An error occurred."));
        this.expectedError.expectErrorType("APP", "MY_TYPE");
        this.flowRunner("customError").run();
    }

    @Test
    public void raisesExistingErrorType() throws Exception {
        this.expectedError.expectMessage(Matchers.is((Object)"An error occurred."));
        this.expectedError.expectErrorType("MULE", "CONNECTIVITY");
        this.flowRunner("existingError").run();
    }

    @Test
    public void handlesStringDescription() throws Exception {
        this.expectedError.expectMessage(Matchers.is((Object)"This is a routing error."));
        this.expectedError.expectErrorType("MULE", "ROUTING");
        this.flowRunner("descriptionString").run();
    }

    @Test
    public void handlesExpressionDescription() throws Exception {
        this.expectedError.expectMessage(Matchers.is((Object)"The error was caused by: test"));
        this.expectedError.expectErrorType("APP", "MY_TYPE");
        ((FlowRunner)((FlowRunner)this.flowRunner("descriptionExpression").withPayload((Object)"test")).withMediaType(MediaType.TEXT)).run();
    }

    @Test
    public void overridesContinue() throws Exception {
        this.expectedError.expectMessage(Matchers.is((Object)"An error occurred."));
        this.expectedError.expectErrorType("APP", "MY_TYPE");
        this.flowRunner("continueOverride").run();
    }

    @Test
    public void overridesPropagatedError() throws Exception {
        this.expectedError.expectMessage(Matchers.is((Object)"An error occurred."));
        this.expectedError.expectErrorType("APP", "MY_TYPE");
        this.flowRunner("propagateOverride").run();
    }

    @Test
    public void canBeHandled() throws Exception {
        Assert.assertThat((Object)this.flowRunner("handled").keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Fatal error.")));
    }

    @Test
    public void withinTryHandle() throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("try").withVariable("continue", (Object)true)).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Try error was handled.")));
    }

    @Test
    public void withinTryPropagate() throws Exception {
        Assert.assertThat((Object)this.flowRunner("try").keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Try error was propagated.")));
    }

    @Test
    public void withinForEach() throws Exception {
        LinkedList<String> payload = new LinkedList<String>();
        payload.add("test");
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("foreach").withPayload(payload)).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"For each failed.")));
    }

    @Test
    public void withinScatterGather() throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("scatter").withPayload((Object)"test")).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Scatter gather route failed.")));
    }

    @Test
    public void withinForEachAndTryScope() throws Exception {
        Assert.assertThat((Object)this.flowRunner("tryAndForEach").run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"Executed OnErrorContinue")));
    }
}

