/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.messaging.meps;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class InOutOutOnlyTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/integration/messaging/meps/pattern_In-Out_Out-Only-flow.xml";
    }

    @Test
    public void testExchangeReceived() throws Exception {
        Message result = ((FlowRunner)((FlowRunner)this.flowRunner("In-Out_Out-Only-Service").withPayload((Object)"some data")).withVariable("foo", (Object)"bar")).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)CoreMatchers.is((Object)"foo header received"));
        result = this.queueManager.read("received", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)CoreMatchers.is((Object)"foo header received"));
    }

    @Test
    public void testExchangeNotReceived() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("In-Out_Out-Only-Service").withPayload((Object)"some data")).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)CoreMatchers.is((Object)"foo header not received"));
        result = this.queueManager.read("notReceived", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)this.getPayloadAsString(result), (Matcher)CoreMatchers.is((Object)"foo header not received"));
    }
}

