/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.test.integration.locator.AbstractLazyInitConfigurationComponentLocatorTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitConfigurationComponentLocatorTestCase
extends AbstractLazyInitConfigurationComponentLocatorTestCase {
    @Test
    public void whenInitializeComponentAndComponentDoesNotExistThenFails() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage("No object found at location non-existent");
        this.lazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"non-existent").build());
    }

    @Description(value="Lazy init should not create components until an operation is done")
    @Test
    public void lazyInitCalculatesLocations() {
        List allLocations = this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList());
        Assert.assertThat((String)allLocations.toString(), allLocations, (Matcher)Matchers.containsInAnyOrder((Object[])EXPECTED_LOCATIONS));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Description(value="Lazy init should create components when operation is done")
    @Test
    public void lazyMuleContextInitializesLocation() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat(this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList()), (Matcher)IsIterableContaining.hasItem((Object)"myFlow/source"));
    }

    @Description(value="Lazy init should refresh the ConfigurationComponentLocator when initialize is done")
    @Test
    public void lazyMuleContextRefreshesConfigurationComponentLoader() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)TOTAL_NUMBER_OF_LOCATIONS));
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("anotherFlow").build());
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)TOTAL_NUMBER_OF_LOCATIONS));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Lazy init should keep siblings enabled when requested")
    @Test
    public void lazyMuleContextSiblingNodesEnabled() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> {
            String location = componentLocation.getLocation();
            return location.equals("myFlow/source") || location.equals("myFlow/processors/2/processors/0");
        });
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)TOTAL_NUMBER_OF_LOCATIONS));
        this.lazyComponentInitializer.initializeComponents(componentLocation -> {
            String location = componentLocation.getLocation();
            return location.equals("myFlow/source") || location.equals("myFlow/processors/2/processors/0");
        });
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void lazyMuleContextShouldInitializeOnlyTheProcessorRequested() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Search for sub-flows components")
    @Test
    public void findSubFlowComponents() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("mySubFlow").addProcessorsPart().addIndexPart(0).build());
        Optional componentOptional = this.locator.find(Location.builder().globalName("mySubFlow").addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)componentOptional.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Description(value="Initialize same flow with redelivery policy configured in a listener, test component should not fail when initializing the second time")
    @Test
    public void whenInitializingComponentsDependingOnComponentsAlreadyInitializedItDoesNotFail() {
        this.assertLocationsNotInitialized("redeliveryPolicyFlowRef1", "redeliveryPolicyFlowRef2", "redeliveryPolicyFlow", "listenerConfigRedeliveryPolicy");
        this.invokeInitializer(Location.builder().globalName("redeliveryPolicyFlowRef1").build());
        this.invokeInitializer(Location.builder().globalName("redeliveryPolicyFlowRef2").build());
        this.assertLocationsInitialized("redeliveryPolicyFlowRef2", "redeliveryPolicyFlow", "listenerConfigRedeliveryPolicy");
    }

    @Override
    protected void invokeInitializer(Location location) {
        this.lazyComponentInitializer.initializeComponent(location);
    }
}

