/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.shutdown;

import static org.mule.runtime.api.util.MuleSystemProperties.DISALLOW_UNTIL_SUCCESSFUL_RETRIES_ON_CRITICAL_ERRORS_PROPERTY;
import static org.mule.runtime.api.util.MuleSystemProperties.RAISE_CANCELLED_ERROR_ON_FORCEFUL_SHUTDOWN_PROPERTY;

import static java.util.concurrent.Executors.newSingleThreadExecutor;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

import java.util.concurrent.ExecutorService;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractShutdownTimeoutRequestResponseTestCase extends AbstractIntegrationTestCase {

  protected static Latch waitLatch;
  protected static Latch contextStopLatch;

  protected ExecutorService executor;

  @Before
  public void before() {
    executor = newSingleThreadExecutor();
  }

  @After
  public void after() {
    executor.shutdownNow();
  }

  @Rule
  public DynamicPort httpPort = new DynamicPort("httpPort");

  @Rule
  public SystemProperty disallowRetryOnCriticalError =
      new SystemProperty(DISALLOW_UNTIL_SUCCESSFUL_RETRIES_ON_CRITICAL_ERRORS_PROPERTY, "true");

  @Rule
  public SystemProperty raiseCancelledErrorOnForcefulShutdown =
      new SystemProperty(RAISE_CANCELLED_ERROR_ON_FORCEFUL_SHUTDOWN_PROPERTY, "true");

  @Before
  public void setUpWaitLatch() throws Exception {
    waitLatch = new Latch();
    contextStopLatch = new Latch();
  }

  public static class BlockMessageProcessor extends AbstractComponent implements Processor {

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
      waitLatch.release();

      try {
        contextStopLatch.await();
      } catch (InterruptedException e) {
        Thread.currentThread().interrupt();
        throw new DefaultMuleException(e);
      }

      return event;
    }
  }

  public static class NoBlockMessageProcessor extends AbstractComponent implements Processor {

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
      waitLatch.release();

      return event;
    }
  }
}
