/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.test.core.context.notification.AbstractNotificationTestCase;
import org.mule.test.core.context.notification.Node;
import org.mule.test.core.context.notification.RestrictedNode;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tests.api.TestQueueManager;

@RunnerDelegateTo(value=Parameterized.class)
public class PipelineMessageNotificationTestCase
extends AbstractNotificationTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    private String flowName;
    private RestrictedNode spec;
    private Consumer<PipelineMessageNotificationTestCase> assertions;

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/pipeline-message-notification-test-flow.xml";
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        return new Object[][]{{"Request-Response", "service-1", null, null, new Node().serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1802))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))), qm -> {}}, {"Request-Response Request Exception", "service-2", DefaultMuleException.class, Arrays.asList("APP", "ERROR"), new Node().serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))), qm -> {}}, {"One-Way", "service-4", null, null, new Node().serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1802))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))), t -> Assert.assertNotNull((Object)t.queueManager.read("ow-out", 5000L, TimeUnit.MILLISECONDS))}, {"One-Way Request Exception", "service-5", null, null, new Node().serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1802))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))), t -> Assert.assertNotNull((Object)t.queueManager.read("owException-out", 5000L, TimeUnit.MILLISECONDS))}, {"One-Way Nested flow-ref Request Exception", "nestedFlowFailingRoot", DefaultMuleException.class, Arrays.asList("APP", "ERROR"), new Node().serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1801))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))).serial(new Node(PipelineMessageNotification.class, (Notification.Action)new IntegerAction(1804))), t -> {}}};
    }

    public PipelineMessageNotificationTestCase(String caseName, String flowName, Class<? extends Throwable> expectedExceptionClass, List<String> expectedErrorType, RestrictedNode spec, Consumer<PipelineMessageNotificationTestCase> assertions) {
        this.flowName = flowName;
        if (expectedExceptionClass != null) {
            this.expectedError.expectCause(Matchers.isA(expectedExceptionClass));
            if (expectedErrorType != null) {
                Assert.assertThat((Object)expectedErrorType.size(), (Matcher)CoreMatchers.is((Object)2));
                this.expectedError.expectErrorType(expectedErrorType.get(0), expectedErrorType.get(1));
            }
        }
        this.spec = spec;
        this.assertions = assertions;
    }

    @Test
    public void doTest() throws Exception {
        try {
            ((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"hi")).run();
        }
        finally {
            this.assertions.accept(this);
            this.assertNotifications();
        }
    }

    @Override
    public RestrictedNode getSpecification() {
        return this.spec;
    }

    @Override
    public void validateSpecification(RestrictedNode spec) throws Exception {
    }
}

