/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.MissingResourceException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.config.InvalidMessageFactory;
import org.mule.test.config.TestI18nMessages;

public class I18nMessagesTestCase
extends AbstractMuleTestCase {
    @Test
    public void testMessageLoading() throws Exception {
        I18nMessage message = CoreMessages.authFailedForUser((Object)"Fred");
        Assert.assertEquals((Object)"Authentication failed for principal Fred", (Object)message.getMessage());
        Assert.assertEquals((long)135L, (long)message.getCode());
    }

    @Test
    public void testBadBundle() {
        try {
            InvalidMessageFactory.getInvalidMessage();
            Assert.fail((String)"should throw resource bundle not found exception");
        }
        catch (MissingResourceException e) {
            Assert.assertTrue((boolean)e.getMessage().matches(".*Can't find.*bundle.*"));
        }
    }

    @Test
    public void testGoodBundle() {
        I18nMessage message = TestI18nMessages.testMessage("one", "two", "three");
        Assert.assertEquals((Object)"Testing, Testing, one, two, three", (Object)message.getMessage());
        Assert.assertEquals((long)1L, (long)message.getCode());
    }
}

