/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.ComponentLocationProvider;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;
import org.springframework.context.annotation.Description;

@Description(value="Test that configuration-based annotations are propagated to the appropriate runtime objects")
@Feature(value="Mule DSL")
@Story(value="Mule DSL Annotations")
public class ConfigurationAnnotationsTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/config/spring/annotations.xml";
    }

    @Test
    public void testFlowAnnotations() {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName("Bridge").get();
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Object)"Bridge flow"));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Object)"Main flow"));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"Bridge\" doc:name=\"Bridge flow\">" + System.lineSeparator() + "<annotations>" + System.lineSeparator() + "<doc:description><![CDATA[" + System.lineSeparator() + "Main flow" + System.lineSeparator() + "]]></doc:description>" + System.lineSeparator() + "</annotations>" + System.lineSeparator() + "<logger doc:name=\"echo\"></logger>" + System.lineSeparator() + "</flow>")));
    }

    @Test
    public void testFlowWithExceptionStrategyAnnotations() {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName("WithRefExceptionStrategy").get();
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Object)"With Referenced Exception Strategy"));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"WithRefExceptionStrategy\" doc:name=\"With Referenced Exception Strategy\">" + System.lineSeparator() + "<logger doc:name=\"echo_ex\"></logger>" + System.lineSeparator() + "<error-handler doc:name=\"error handler doc name\">" + System.lineSeparator() + "<on-error-continue doc:name=\"On Error Continue\">" + System.lineSeparator() + "<logger message=\"Exception! \" level=\"ERROR\" doc:name=\"Logger\"></logger>" + System.lineSeparator() + "</on-error-continue>" + System.lineSeparator() + "</error-handler>" + System.lineSeparator() + "</flow>")));
    }

    @Test
    public void testDefaultAnnotationsInNotAnnotatedObject() {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName("NotAnnotatedBridge").get();
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"NotAnnotatedBridge\">" + System.lineSeparator() + "<logger></logger>" + System.lineSeparator() + "</flow>")));
    }

    @Test
    public void testJavaComponentAnnotations() {
        Flow flow = (Flow)this.registry.lookupByName("Bridge").get();
        Processor logger = (Processor)flow.getProcessors().get(0);
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)((Component)logger)), (Matcher)CoreMatchers.is((Object)"<logger doc:name=\"echo\"></logger>"));
    }

    @Test
    @Issue(value="MULE-19631")
    public void annotationAvailableInComponent() {
        Flow flow = (Flow)this.registry.lookupByName("withCustomAnnotation").get();
        Assert.assertThat((Object)flow.getAnnotation(new QName("http://www.my-org.org/schema/custom", "anything")), (Matcher)CoreMatchers.is((Object)"This is something custom"));
    }

    protected String getDocName(Object obj) {
        return (String)((Component)obj).getAnnotation(Component.Annotations.NAME_ANNOTATION_KEY);
    }

    protected String getDocDescription(Object obj) {
        return (String)((Component)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "description"));
    }
}

