/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class OnErrorContinueFlowRefTestCase
extends AbstractIntegrationTestCase {
    public static final int TIMEOUT = 5000;
    private final String config;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Local Error Handler", "org/mule/test/integration/exceptions/on-error-continue-flow-ref.xml"}, {"Global Error Handler", "org/mule/test/integration/exceptions/on-error-continue-flow-ref-global-err.xml"});
    }

    public OnErrorContinueFlowRefTestCase(String type, String config) {
        this.config = config;
    }

    protected String getConfigFile() {
        return this.config;
    }

    @Test
    public void testFlowRefHandlingException() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("exceptionHandlingBlock").withPayload((Object)"{\"userId\":\"15\"}")).run().getMessage();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(this.getPayloadAsString(response));
        JsonNode expectedJsonNode = mapper.readTree("{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}");
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    @Test
    public void testFlowRefHandlingExceptionWithTransaction() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("transactionNotResolvedAfterException").withPayload((Object)"{\"userId\":\"15\"}")).run().getMessage();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(this.getPayloadAsString(response));
        JsonNode expectedJsonNode = mapper.readTree("{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}");
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    public static class VerifyTransactionNotResolvedProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            Assert.assertThat((Object)tx, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)tx.isRollbackOnly(), (Matcher)Is.is((Object)false));
            return event;
        }
    }
}

