/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Global Error handlers and 'circular references'")
public class GlobalErrorHandlerTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/global-error-handler.xml";
    }

    @Test
    @Issue(value="MULE-18439")
    @Description(value="Flow with error handler reference and name matching")
    public void errorHandlerWithSelfReference() throws Exception {
        CoreEvent event = this.flowRunner("flowWithErrorHandlerSelfReferencing").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"Chocotorta"));
    }

    @Test
    @Issue(value="MULE-18439")
    @Description(value="Flow with error handler with on-error-continue reference and name matching")
    public void errorHandlerWithSelfReferenceToContinue() throws Exception {
        CoreEvent event = this.flowRunner("flowWithErrorHandlerSelfReferencingContinue").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"Sachertorte"));
    }

    @Test
    @Issue(value="MULE-18439")
    @Description(value="Flow with error handler with on-error-continue reference and name matching, and matching on-error-continue in global error handler")
    public void errorHandlerWithSelfReferenceToContinueReferencedInGlobalEH() throws Exception {
        CoreEvent event = this.flowRunner("flowWithErrorHandlerSelfReferencingToReferencedContinue").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"Lemon Pie"));
    }
}

