/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.dsl;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Mule DSL")
@Story(value="Mule DSL Parsing")
public class DslComponentsDependencyOrderTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort httpPort1 = new DynamicPort("httpPort1");
    @Rule
    public DynamicPort httpPort2 = new DynamicPort("httpPort2");

    protected String getConfigFile() {
        return "org/mule/test/config/component-dependency-config.xml";
    }

    @Description(value="Verifies that lifecycle is applied correctly despite the order of the components in the configuration")
    @Test
    public void configurationComponentDependencyOrder() throws Exception {
        String clientFlowName = "clientFlow";
        String portVarName = "port";
        String value = (String)((FlowRunner)this.flowRunner(clientFlowName).withVariable(portVarName, (Object)this.httpPort1.getValue())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"listener1"));
        value = (String)((FlowRunner)this.flowRunner(clientFlowName).withVariable(portVarName, (Object)this.httpPort2.getValue())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"listener2"));
    }
}

