/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Error Handler")
public class ExpressionsOnErrorsTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort wireMockPort = new DynamicPort("wireMockPort");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").port(this.wireMockPort.getNumber()));

    @Before
    public void setUp() {
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/500")).willReturn(WireMock.aResponse().withStatus(500)));
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/expressions-on-errors.xml";
    }

    @Test
    public void detailedDescription() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner("detailedDescription").run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"An expected error occurred."));
    }

    @Test
    public void infoElement() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner("infoElement").run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"infoElement/processors/0 @ ExpressionsOnErrorsTestCase#infoElement:org/mule/test/integration/exceptions/expressions-on-errors.xml:18"));
    }

    @Test
    public void infoElementSdkOp() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner("infoElementSdkOp").run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"infoElementSdkOp/processors/0 @ ExpressionsOnErrorsTestCase#infoElementSdkOp:org/mule/test/integration/exceptions/expressions-on-errors.xml:27"));
    }

    @Test
    @Issue(value="MULE-18535")
    public void infoElementDeprecated() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner("infoElementDeprecated").run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"infoElementDeprecated/processors/0 @ ExpressionsOnErrorsTestCase#infoElementDeprecated:org/mule/test/integration/exceptions/expressions-on-errors.xml:36"));
    }

    @Test
    @Issue(value="MULE-18666")
    public void mesageToJson() throws Exception {
        CursorStreamProvider value = (CursorStreamProvider)((FlowRunner)((FlowRunner)this.flowRunner("messageToJson").keepStreamsOpen().withPayload((Object)"Hello World!")).withAttributes((Object)"Adios Amigos")).run().getMessage().getPayload().getValue();
        String result = IOUtils.toString((InputStream)((InputStream)value.openCursor()), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"\n  \"payload\": \"Hello World!\",\n"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"\n  \"attributes\": \"Adios Amigos\"\n"));
    }
}

