/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.connection;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Reconnection Policies")
@Story(value="Blocking")
@RunnerDelegateTo(value=Parameterized.class)
public class ReconnectionTestCase
extends AbstractIntegrationTestCase {
    private String flow;

    public ReconnectionTestCase(String flow) {
        this.flow = flow;
    }

    @Parameterized.Parameters(name="flow: {0}")
    public static List<String> parameters() {
        return Arrays.asList("reconnectionTest", "reconnectionWithDynamicConfigTest", "noReconnectionTest", "noReconnectionWithDynamicConfigTest");
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/connection/reconnection-config.xml";
    }

    @Test
    public void executedOperationThrowsConnectivityError() throws Exception {
        this.testReconnectionFlow(this.flow);
    }

    private void testReconnectionFlow(String flowName) throws Exception {
        this.flowRunner(flowName).runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
    }
}

