/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Scope")
@Story(value="Until Successful")
@RunnerDelegateTo(value=Parameterized.class)
public class UntilSuccessfulRetryExhaustedTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty suppressErrors;
    @Inject
    private TestQueueManager queueManager;
    @Inject
    private ObjectSerializer defaultSerializer;
    private final boolean isSuppressErrors;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/until-successful-retry-exhausted.xml";
    }

    @Parameterized.Parameters(name="Suppress errors: {0}")
    public static Collection<String> parameters() {
        return Arrays.asList("true", "false");
    }

    public UntilSuccessfulRetryExhaustedTestCase(String suppressErrors) {
        this.suppressErrors = new SystemProperty("mule.suppress.mule.exceptions", suppressErrors);
        this.isSuppressErrors = Boolean.parseBoolean(suppressErrors);
    }

    @Test
    public void onRetryExhaustedCallExceptionStrategy() throws Exception {
        Latch exceptionStrategyCalledLatch = new Latch();
        this.notificationListenerRegistry.registerListener((NotificationListener)((ExceptionNotificationListener)notification -> exceptionStrategyCalledLatch.release()));
        ((FlowRunner)this.flowRunner("retryExhaustedCausedByUntypedError").withPayload((Object)"message")).run();
        if (!exceptionStrategyCalledLatch.await(10000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception strategy was not executed");
        }
    }

    @Test
    public void onNestedRetryExhaustedCallExceptionStrategy() throws Exception {
        Latch exceptionStrategyCalledLatch = new Latch();
        this.notificationListenerRegistry.registerListener((NotificationListener)((ExceptionNotificationListener)notification -> exceptionStrategyCalledLatch.release()));
        ((FlowRunner)this.flowRunner("retryExhaustedCausedByUntypedError").withPayload((Object)"message")).run();
        if (!exceptionStrategyCalledLatch.await(10000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception strategy was not executed");
        }
    }

    @Test
    public void onRetryExhaustedCausedByConnectionExceptionErrorTypeMustBeRetryExhausted() throws Exception {
        if (this.isSuppressErrors()) {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByConnectivityError").withPayload((Object)"message")).runExpectingException(ErrorTypeMatcher.errorType((ErrorTypeDefinition)MuleErrors.RETRY_EXHAUSTED));
        } else {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByConnectivityError").withPayload((Object)"message")).runExpectingException(ErrorTypeMatcher.errorType((ErrorTypeDefinition)MuleErrors.CONNECTIVITY));
        }
    }

    private boolean isSuppressErrors() {
        return Boolean.parseBoolean(this.suppressErrors.getValue());
    }

    @Test
    @Issue(value="MULE-18041")
    public void retryExhaustedCausedByConnectionExceptionLogCheck() throws Exception {
        if (this.isSuppressErrors()) {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByConnectivityErrorWithSuppressionLogCheck").withPayload((Object)"message")).run();
        } else {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByConnectivityErrorWithoutSuppressionLogCheck").withPayload((Object)"message")).run();
        }
    }

    @Test
    @Issue(value="MULE-18041")
    public void retryExhaustedCausedByNonConnectionExceptionLogCheck() throws Exception {
        if (this.isSuppressErrors()) {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByNonConnectivityErrorWithSuppressionLogCheck").withPayload((Object)"message")).run();
        } else {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByNonConnectivityErrorWithoutSuppressionLogCheck").withPayload((Object)"message")).run();
        }
    }

    @Test
    @Issue(value="MULE-18041")
    public void retryExhaustedCausedByMuleRuntimeExceptionLogCheck() throws Exception {
        if (this.isSuppressErrors()) {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByMuleRuntimeErrorWithSuppressionLogCheck").withPayload((Object)"message")).run();
        } else {
            ((FlowRunner)this.flowRunner("retryExhaustedCausedByMuleRuntimeErrorWithoutSuppressionLogCheck").withPayload((Object)"message")).run();
        }
    }

    @Test
    @Issue(value="MULE-18562")
    public void retryExhaustedUnsuppressedErrorTypeHandling() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("retryExhaustedUnsuppressedErrorTypeHandling").withPayload((Object)"message")).run();
        if (this.isSuppressErrors()) {
            MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"retry-exhausted-handled"));
        } else {
            MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"security-handled"));
        }
    }

    @Test
    @Issue(value="MULE-18562")
    public void retryExhaustedSuppressedErrorTypeHandling() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("retryExhaustedSuppressedErrorTypeHandling").withPayload((Object)"message")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"handled"));
    }

    @Test
    @Issue(value="MULE-18562")
    public void retryExhaustedErrorWithSuppressionsCheck() throws Exception {
        ((FlowRunner)this.flowRunner("retryExhaustedErrorWithSuppressionsCheck").withPayload((Object)"message")).run();
        Error error = (Error)this.queueManager.read("dlq", 5000L, TimeUnit.MILLISECONDS).getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class));
        MatcherAssert.assertThat((Object)error.getDescription(), (Matcher)IsEqual.equalTo((Object)"Mule runtime error"));
        MatcherAssert.assertThat((Object)error.getDetailedDescription(), (Matcher)IsEqual.equalTo((Object)"'until-successful' retries exhausted"));
        MatcherAssert.assertThat((Object)error.getFailingComponent(), (Matcher)CoreMatchers.containsString((String)"retryExhaustedErrorWithSuppressionsCheck/processors/0"));
        MatcherAssert.assertThat((Object)error.getErrorMessage(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)error.getChildErrors(), (Matcher)IsEmptyCollection.empty());
        if (this.isSuppressErrors()) {
            MatcherAssert.assertThat((Object)error.getErrorType().toString(), (Matcher)IsEqual.equalTo((Object)"MULE:RETRY_EXHAUSTED"));
        } else {
            MatcherAssert.assertThat((Object)error.getErrorType().toString(), (Matcher)IsEqual.equalTo((Object)"MULE:SECURITY"));
        }
    }

    @Test
    @Issue(value="W-15643200")
    public void retryExhaustedErrorSerializationCheck() throws Exception {
        ((FlowRunner)this.flowRunner("retryExhaustedErrorSerializationCheck").withPayload((Object)"message")).run();
        Error error = (Error)this.queueManager.read("dlq", 5000L, TimeUnit.MILLISECONDS).getMessage().getPayload().getValue();
        byte[] errorSerialization = this.defaultSerializer.getInternalProtocol().serialize((Object)error);
        Error errorDeserialization = (Error)this.defaultSerializer.getInternalProtocol().deserialize(errorSerialization);
        MatcherAssert.assertThat((Object)errorDeserialization.getCause(), (Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class));
        MatcherAssert.assertThat((Object)errorDeserialization.getDescription(), (Matcher)IsEqual.equalTo((Object)"Mule runtime error"));
    }

    @Test
    @Issue(value="W-15643200")
    public void retryExhaustedLegacyErrorSerializationCheck() throws Exception {
        try (InputStream errorSerializationInputStream = this.getClass().getResourceAsStream(String.format("UntilSuccessfulRetryExhaustedTestCase_retryExhaustedErrorSerializationCheck%s.bin", this.isSuppressErrors ? "_suppressedTrue" : "_suppressedFalse"));){
            Error deserializedError = (Error)this.defaultSerializer.getInternalProtocol().deserialize(errorSerializationInputStream);
            MatcherAssert.assertThat((Object)deserializedError.getCause(), (Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class));
            MatcherAssert.assertThat((Object)deserializedError.getDescription(), (Matcher)IsEqual.equalTo((Object)"Mule runtime error"));
        }
    }

    public static class MuleRuntimeError
    extends MuleRuntimeException {
        public MuleRuntimeError() {
            super(I18nMessageFactory.createStaticMessage((String)"Mule runtime error"));
        }
    }
}

