/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.http;

import io.qameta.allure.Issue;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@Ignore(value="MULE-10633")
@Issue(value="MULE-10633")
public class HttpSharePortTestCase
extends DomainFunctionalTestCase {
    public static final String HELLO_WORLD_SERVICE_APP = "helloWorldServiceApp";
    public static final String HELLO_MULE_SERVICE_APP = "helloMuleServiceApp";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder().tlsContextFactory(this.getTlsContextFactory()).build();

    protected String getDomainConfig() {
        return "domain/http/http-shared-listener-config.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig(HELLO_WORLD_SERVICE_APP, new String[]{"domain/http/http-hello-world-app.xml"}), new DomainFunctionalTestCase.ApplicationConfig(HELLO_MULE_SERVICE_APP, new String[]{"domain/http/http-hello-mule-app.xml"})};
    }

    @Test
    public void bothServicesBindCorrectly() throws Exception {
        HttpRequest httpRequest = HttpRequest.builder().uri(String.format("%s://localhost:%d/service/helloWorld", this.endpointScheme.getValue(), this.dynamicPort.getNumber())).build();
        HttpResponse httpResponse = this.httpClient.send(httpRequest, 5000, false, null);
        String payload = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)payload, (Matcher)Is.is((Object)"hello world"));
        httpRequest = HttpRequest.builder().uri(String.format("%s://localhost:%d/service/helloMule", this.endpointScheme.getValue(), this.dynamicPort.getNumber())).build();
        httpResponse = this.httpClient.send(httpRequest, 5000, false, null);
        payload = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)payload, (Matcher)Is.is((Object)"hello mule"));
    }

    protected SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }

    protected TlsContextFactory getTlsContextFactory() {
        return null;
    }
}

