/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

public class DslConstantsRoutersFlowTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public String getConfigFile() {
        return "core-namespace-routers-flow.xml";
    }

    @Test
    public void testIdempotentSecureHashReceiverRouter() throws Exception {
        Processor router = this.lookupMessageProcessorFromFlow("IdempotentSecureHashReceiverRouter");
        Assert.assertThat((Object)router.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.routing.IdempotentMessageValidator"));
    }

    @Test
    public void testIdempotentReceiverRouter() throws Exception {
        Processor router = this.lookupMessageProcessorFromFlow("IdempotentReceiverRouter");
        Assert.assertThat((Object)router.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.routing.IdempotentMessageValidator"));
        Assert.assertThat((Object)router.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.routing.IdempotentMessageValidator"));
    }

    @Test
    public void testIdempotentReceiverRouterError() throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("IdempotentReceiverRouterVar").withVariable("otherId", (Object)"123")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"Not duplicate"));
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("IdempotentReceiverRouterVar").withVariable("otherId", (Object)"123")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"Duplicate"));
    }

    @Test
    public void testSecureHashIdempotentReceiverRouterError() throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("IdempotentSecureHashReceiverRouterVar").withVariable("otherId", (Object)"123")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"Not duplicate"));
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("IdempotentSecureHashReceiverRouterVar").withVariable("otherId", (Object)"123")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"Duplicate"));
    }

    @Test
    public void testNonExistentHashingShouldNotExist() throws Exception {
        this.expectedException.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        ((FlowRunner)this.flowRunner("nonExistentHashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testMD2HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("md2HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testMD5HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("md5HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testSHA1HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("sha1HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testSHA224HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("sha224HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testSHA256HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("sha256HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testSHA384HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("sha384HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    @Test
    public void testSHA512HashingShouldExist() throws Exception {
        ((FlowRunner)this.flowRunner("sha512HashFlow").withVariable("otherId", (Object)"123")).run();
    }

    protected Processor lookupMessageProcessorFromFlow(String flowName) throws Exception {
        Flow flow = this.lookupFlow(flowName);
        List routers = flow.getProcessors();
        Assert.assertEquals((long)1L, (long)routers.size());
        return (Processor)routers.get(0);
    }

    protected Flow lookupFlow(String flowName) {
        return (Flow)this.registry.lookupByName(flowName).get();
    }
}

