/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class ValidShutdownTimeoutRequestResponseTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "5000");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    @After
    public void disposeHttpClient() {
        this.httpClient.stop();
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    protected String getConfigFile() {
        return "org/mule/shutdown/shutdown-timeout-request-response-config.xml";
    }

    @Test
    public void testScriptComponent() throws Throwable {
        this.doShutDownTest("scriptComponentResponse", "http://localhost:" + this.httpPort.getNumber() + "/scriptComponent");
    }

    @Test
    public void testSetPayload() throws Throwable {
        this.doShutDownTest("setPayloadResponse", "http://localhost:" + this.httpPort.getNumber() + "/setPayload");
    }

    @Test
    public void testSetPayloadChoice() throws Throwable {
        this.doShutDownTest("setPayloadResponse", "http://localhost:" + this.httpPort.getNumber() + "/setPayloadChoice");
    }

    @Test
    public void testSetPayloadTx() throws Throwable {
        this.doShutDownTest("setPayloadResponse", "http://localhost:" + this.httpPort.getNumber() + "/setPayloadTx");
    }

    private void doShutDownTest(String payload, String url) throws Throwable {
        Future<?> requestTask = this.executor.submit(() -> new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(url).method(HttpConstants.Method.GET).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes()))).build();
            HttpResponse response = this.httpClient.send(request, 5000, false, null);
            Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)payload));
            return true;
        })));
        waitLatch.await();
        contextStopLatch.release();
        muleContext.stop();
        try {
            requestTask.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

