/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Error Handling")
@Story(value="Redelivery Exceeded")
public class RedeliveryExhaustedTestCase
extends AbstractIntegrationTestCase {
    private static final int MAX_REDELIVERY_COUNT = 2;
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty maxRedeliveryCount = new SystemProperty("maxRedeliveryCount", "2");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/redelivery-exhausted.xml";
    }

    @Test
    @Description(value="Test that the required troubleshooting information is in the redelivery error.")
    public void exhaustRedelivery() throws IOException, TimeoutException {
        for (int i = 0; i < 3; ++i) {
            Assert.assertThat((Object)this.sendThroughHttp().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        }
        HttpResponse response = this.sendThroughHttp();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getStatusCode()));
        CoreEvent event = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS);
        Error error = (Error)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)error.getErrorType().getIdentifier(), (Matcher)Is.is((Object)"REDELIVERY_EXHAUSTED"));
        Assert.assertThat((Object)error.getChildErrors(), (Matcher)Matchers.hasSize((int)3));
        for (Error childError : error.getChildErrors()) {
            Assert.assertThat((Object)childError.getErrorType().getIdentifier(), (Matcher)Is.is((Object)"ROUTING"));
        }
    }

    @Test
    @Issue(value="MULE-19915")
    @Description(value="Test that once the redelivery is exhausted for a message from a source configured with transactions, the transaction is not rollbacked by the source because of the flow finishing with an error.")
    public void redeliveryExhaustedWithTransactionalSourceAndCustomErrorHandler() throws Exception {
        this.flowRunner("redeliveryExhaustedWithTransactionalSourceAndCustomErrorHandlerDispatch").runExpectingException();
        this.assertRedeliveryExhaustedErrorRaisedOnlyOnce("customErrorHandler");
    }

    @Test
    @Issue(value="MULE-19915")
    @Description(value="Test that once the redelivery is exhausted for a message from a source configured with transactions, the transaction is not rollbacked by the error handler.")
    public void redeliveryExhaustedWithTransactionalSourceAndDefaultErrorHandler() throws Exception {
        this.flowRunner("redeliveryExhaustedWithTransactionalSourceAndDefaultErrorHandlerDispatch").runExpectingException();
        this.assertRedeliveryExhaustedErrorRaisedOnlyOnce("defaultErrorHandler");
    }

    private void assertRedeliveryExhaustedErrorRaisedOnlyOnce(String queueName) {
        Assert.assertThat((String)"Message redelivery not exhausted", (Object)this.queueManager.read(queueName, 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
        Assert.assertThat((String)"Redelivery exhausted error not thrown more than once", (Object)this.queueManager.read(queueName, 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
    }

    private HttpResponse sendThroughHttp() throws IOException, TimeoutException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUrl()).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).build();
        return this.httpClient.send(request, 5000, false, null);
    }

    private String getUrl() {
        return String.format("http://localhost:%s/exhaustRedelivery", this.port.getNumber());
    }
}

